/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.undertow.wildfly;

import io.undertow.server.HttpHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.core.ManagedServlet;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.transport.undertow.AbstractHTTPServerEngine;
import org.apache.cxf.transport.undertow.UndertowHTTPDestination;
import org.apache.cxf.transport.undertow.UndertowHTTPHandler;
import org.jboss.gravia.runtime.ServiceLocator;
import org.wildfly.extension.undertow.Host;

class WildflyHTTPServerEngine
extends AbstractHTTPServerEngine {
    private final Host defaultHost = (Host)ServiceLocator.getRequiredService(Host.class);
    private DeploymentManager manager;

    WildflyHTTPServerEngine(String protocol, String host, int port) {
        super(protocol, host, port);
    }

    public void addServant(URL nurl, UndertowHTTPHandler handler) {
        ServletInfo servletInfo = Servlets.servlet((String)"DefaultServlet", DefaultServlet.class).addMapping("/*");
        DeploymentInfo servletBuilder = Servlets.deployment().setClassLoader(WildflyHTTPServerEngine.class.getClassLoader()).setContextPath(nurl.getPath()).setDeploymentName("cxfdestination.war").addServlets(new ServletInfo[]{servletInfo});
        this.manager = Servlets.defaultContainer().addDeployment(servletBuilder);
        this.manager.deploy();
        try {
            HttpHandler servletHandler = this.manager.start();
            this.defaultHost.registerDeployment(this.manager.getDeployment(), servletHandler);
            UndertowHTTPDestination destination = handler.getHTTPDestination();
            destination.setServletContext((ServletContext)this.manager.getDeployment().getServletContext());
            ManagedServlet managedServlet = this.manager.getDeployment().getServlets().getManagedServlet("DefaultServlet");
            DefaultServlet servletInstance = (DefaultServlet)((Object)managedServlet.getServlet().getInstance());
            servletInstance.setHTTPDestination(destination);
        }
        catch (ServletException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void removeServant(URL nurl) {
        if (this.manager != null) {
            this.defaultHost.unregisterDeployment(this.manager.getDeployment());
        }
    }

    static class DefaultServlet
    extends HttpServlet {
        private UndertowHTTPDestination destination;

        DefaultServlet() {
        }

        void setHTTPDestination(UndertowHTTPDestination destination) {
            this.destination = destination;
        }

        protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            this.destination.doService(req, res);
        }
    }
}

