/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.wildfly;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class WildFlyCatalogCreator {
    final Path basedir = Paths.get(System.getProperty("basedir"), new String[0]);
    final Path resdir = this.basedir.resolve(Paths.get("src/main/resources", new String[0]));
    final Path srcdir = this.basedir.resolve(Paths.get("target/camel-catalog", new String[0]));
    final Path outdir = this.basedir.resolve(Paths.get("target/classes", new String[0]));
    Map<Kind, RoadMap> roadmaps = new HashMap<Kind, RoadMap>();

    public WildFlyCatalogCreator() {
        this.roadmaps.put(Kind.component, new RoadMap(Kind.component));
        this.roadmaps.put(Kind.dataformat, new RoadMap(Kind.dataformat));
        this.roadmaps.put(Kind.language, new RoadMap(Kind.language));
    }

    public static void main(String[] args) throws Exception {
        new WildFlyCatalogCreator().createCatalog();
    }

    private void createCatalog() throws Exception {
        this.collectAvailable();
        this.collectSupported();
        this.generateProperties();
        this.generateRoadmaps();
    }

    private void collectAvailable() throws IOException {
        Files.walkFileTree(this.srcdir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                if (path.toString().endsWith(".json")) {
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode tree = mapper.readTree(path.toFile());
                    String kind = tree.findValue("kind").textValue();
                    String javaType = tree.findValue("javaType").textValue();
                    if (this.validKind(kind) && javaType != null) {
                        Item item = new Item(WildFlyCatalogCreator.this.srcdir.relativize(path), Kind.valueOf(kind), javaType);
                        WildFlyCatalogCreator.this.roadmaps.get((Object)item.kind).add(item);
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            boolean validKind(String kind) {
                try {
                    Kind.valueOf(kind);
                    return true;
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
        });
        for (RoadMap roadmap : this.roadmaps.values()) {
            State state = null;
            File file = roadmap.outpath.toFile();
            try {
                BufferedReader br = new BufferedReader(new FileReader(file));
                Throwable throwable = null;
                try {
                    String line = br.readLine();
                    while (line != null) {
                        if (line.length() > 0 && !line.startsWith("#")) {
                            Item item;
                            if (line.equals("[" + (Object)((Object)State.planned) + "]")) {
                                state = State.planned;
                            } else if (line.equals("[" + (Object)((Object)State.rejected) + "]")) {
                                state = State.rejected;
                            } else if (line.startsWith("[")) {
                                state = null;
                            } else if (state != null && (item = roadmap.item(line.trim())) != null) {
                                item.state = state;
                            }
                        }
                        line = br.readLine();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (br == null) continue;
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    br.close();
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private void collectSupported() throws IOException {
        Path rootPath = this.basedir.resolve(Paths.get("target", "dependency"));
        for (RoadMap roadmap : this.roadmaps.values()) {
            for (Item item : roadmap.items.values()) {
                Path javaType = Paths.get(item.javaType.replace('.', '/') + ".class", new String[0]);
                if (!rootPath.resolve(javaType).toFile().isFile()) continue;
                Path target = this.outdir.resolve(item.path);
                Path source = this.srcdir.resolve(item.path);
                target.getParent().toFile().mkdirs();
                Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                item.state = State.supported;
            }
        }
    }

    private void generateProperties() throws IOException {
        for (RoadMap roadmap : this.roadmaps.values()) {
            File outfile = this.outdir.resolve("org/apache/camel/catalog/" + (Object)((Object)roadmap.kind) + "s.properties").toFile();
            PrintWriter pw = new PrintWriter(outfile);
            Throwable throwable = null;
            try {
                for (String name : roadmap.sortedNames(State.supported)) {
                    pw.println(name);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pw == null) continue;
                if (throwable != null) {
                    try {
                        pw.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                pw.close();
            }
        }
    }

    private void generateRoadmaps() throws IOException {
        for (RoadMap roadmap : this.roadmaps.values()) {
            PrintWriter pw = new PrintWriter(roadmap.outpath.toFile());
            Throwable throwable = null;
            try {
                for (State state : State.values()) {
                    pw.println("[" + (Object)((Object)state) + "]");
                    for (String entry : roadmap.sortedNames(state)) {
                        pw.println(entry);
                    }
                    pw.println();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pw == null) continue;
                if (throwable != null) {
                    try {
                        pw.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                pw.close();
            }
        }
    }

    class RoadMap {
        final Kind kind;
        final Path outpath;
        final Map<String, Item> items = new HashMap<String, Item>();

        RoadMap(Kind kind) {
            this.outpath = WildFlyCatalogCreator.this.resdir.resolve((Object)((Object)kind) + ".roadmap");
            this.kind = kind;
        }

        void add(Item item) {
            this.items.put(item.name, item);
        }

        Item item(String name) {
            return this.items.get(name);
        }

        List<String> sortedNames(State state) {
            ArrayList<String> result = new ArrayList<String>();
            for (Item item : this.items.values()) {
                if (item.state != state) continue;
                result.add(item.name);
            }
            Collections.sort(result);
            return result;
        }
    }

    class Item {
        final Path path;
        final Kind kind;
        final String name;
        final String javaType;
        State state = State.undecided;

        Item(Path path, Kind kind, String javaType) {
            this.path = path;
            this.kind = kind;
            this.javaType = javaType;
            String nspec = path.getFileName().toString();
            this.name = nspec = nspec.substring(0, nspec.indexOf("."));
        }
    }

    static enum State {
        supported,
        planned,
        undecided,
        rejected;

    }

    static enum Kind {
        component,
        dataformat,
        language;

    }
}

