/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.catalog.CatalogHelper;
import org.apache.camel.catalog.DefaultRuntimeProvider;

public class WildFlyRuntimeProvider
extends DefaultRuntimeProvider {
    private static final String COMPONENT_DIR = "org/wildfly/camel/catalog/components";
    private static final String DATAFORMAT_DIR = "org/wildfly/camel/catalog/dataformats";
    private static final String LANGUAGE_DIR = "org/wildfly/camel/catalog/languages";
    private static final String COMPONENTS_CATALOG = "org/wildfly/camel/catalog/components.properties";
    private static final String DATA_FORMATS_CATALOG = "org/wildfly/camel/catalog/dataformats.properties";
    private static final String LANGUAGE_CATALOG = "org/wildfly/camel/catalog/languages.properties";

    public String getProviderName() {
        return "wildfly";
    }

    public String getComponentJSonSchemaDirectory() {
        return COMPONENT_DIR;
    }

    public String getDataFormatJSonSchemaDirectory() {
        return DATAFORMAT_DIR;
    }

    public String getLanguageJSonSchemaDirectory() {
        return LANGUAGE_DIR;
    }

    public List<String> findComponentNames() {
        ArrayList<String> names = new ArrayList<String>();
        InputStream is = this.getCamelCatalog().getVersionManager().getResourceAsStream(COMPONENTS_CATALOG);
        if (is != null) {
            try {
                CatalogHelper.loadLines((InputStream)is, names);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return names;
    }

    public List<String> findDataFormatNames() {
        ArrayList<String> names = new ArrayList<String>();
        InputStream is = this.getCamelCatalog().getVersionManager().getResourceAsStream(DATA_FORMATS_CATALOG);
        if (is != null) {
            try {
                CatalogHelper.loadLines((InputStream)is, names);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return names;
    }

    public List<String> findLanguageNames() {
        ArrayList<String> names = new ArrayList<String>();
        InputStream is = this.getCamelCatalog().getVersionManager().getResourceAsStream(LANGUAGE_CATALOG);
        if (is != null) {
            try {
                CatalogHelper.loadLines((InputStream)is, names);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return names;
    }
}

