/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.config;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.wildfly.extras.config.ConfigContext;
import org.wildfly.extras.config.ConfigPlugin;
import org.wildfly.extras.config.ConfigSupport;
import org.wildfly.extras.config.LayerConfig;
import org.wildfly.extras.config.NamespaceRegistry;

public final class WildFlyCamelConfigPlugin
implements ConfigPlugin {
    public static final String NS_CAMEL = "urn:jboss:domain:camel";
    private NamespaceRegistry registry;

    public WildFlyCamelConfigPlugin() {
        this.registerNamespaceVersions(new NamespaceRegistry());
    }

    public WildFlyCamelConfigPlugin(NamespaceRegistry registry) {
        this.registerNamespaceVersions(registry);
    }

    public String getConfigName() {
        return "camel";
    }

    public List<LayerConfig> getLayerConfigs() {
        return Arrays.asList(LayerConfig.FUSE_LAYER);
    }

    public void applyStandaloneConfigChange(ConfigContext context, boolean enable) {
        this.updateExtension(context, enable);
        this.updateSystemProperties(context, enable);
        this.updateSubsystem(context, enable);
        this.updateSecurityDomain(context, enable);
    }

    public void applyDomainConfigChange(ConfigContext context, boolean enable) {
        this.applyStandaloneConfigChange(context, enable);
        this.updateServergroup(enable, context);
    }

    private void updateExtension(ConfigContext context, boolean enable) {
        Namespace[] domainNamespaces = this.registry.getNamespaces("urn:jboss:domain");
        Element extensions = ConfigSupport.findChildElement((Element)context.getDocument().getRootElement(), (String)"extensions", (Namespace[])domainNamespaces);
        ConfigSupport.assertExists((Element)extensions, (String)"Did not find the <extensions> element");
        Element element = ConfigSupport.findElementWithAttributeValue((Element)extensions, (String)"extension", (String)"module", (String)"org.wildfly.extension.camel", (Namespace[])domainNamespaces);
        Namespace domainNamespace = context.getDocument().getRootElement().getNamespace();
        if (enable && element == null) {
            extensions.addContent((Content)new Text("    "));
            extensions.addContent((Content)new Element("extension", domainNamespace).setAttribute("module", "org.wildfly.extension.camel"));
            extensions.addContent((Content)new Text("\n    "));
        }
        if (!enable && element != null) {
            element.getParentElement().removeContent((Content)element);
        }
    }

    private void updateSystemProperties(ConfigContext context, boolean enable) {
        Namespace[] domainNamespaces = this.registry.getNamespaces("urn:jboss:domain");
        Namespace domainNamespace = context.getDocument().getRootElement().getNamespace();
        Element rootElement = context.getDocument().getRootElement();
        Element element = ConfigSupport.findChildElement((Element)rootElement, (String)"system-properties", (Namespace[])domainNamespaces);
        if (element == null) {
            element = new Element("system-properties", domainNamespace);
            element.addContent((Content)new Text("\n    "));
            int pos = rootElement.indexOf((Content)rootElement.getChild("extensions", domainNamespace));
            rootElement.addContent(pos + 1, (Content)new Text("    "));
            rootElement.addContent(pos + 1, (Content)element);
            rootElement.addContent(pos + 1, (Content)new Text("\n"));
        }
        Map propertiesByName = ConfigSupport.mapByAttributeName((List)element.getChildren(), (String)"name");
        if (enable) {
            this.addProperty(element, propertiesByName, "hawtio.authenticationEnabled", "true", domainNamespace);
            this.addProperty(element, propertiesByName, "hawtio.offline", "true", domainNamespace);
            this.addProperty(element, propertiesByName, "hawtio.realm", "hawtio-domain", domainNamespace);
        } else {
            this.removeProperty(propertiesByName, "hawtio.authenticationEnabled");
            this.removeProperty(propertiesByName, "hawtio.offline");
            this.removeProperty(propertiesByName, "hawtio.realm");
        }
    }

    private void updateSubsystem(ConfigContext context, boolean enable) {
        Namespace[] domainNamespaces = this.registry.getNamespaces("urn:jboss:domain");
        Namespace[] camelNamespaces = this.registry.getNamespaces(NS_CAMEL);
        List profiles = ConfigSupport.findProfileElements((Document)context.getDocument(), (Namespace[])domainNamespaces);
        for (Element profile : profiles) {
            Element element = ConfigSupport.findChildElement((Element)profile, (String)"subsystem", (Namespace[])camelNamespaces);
            if (enable && element == null) {
                URL resource = WildFlyCamelConfigPlugin.class.getResource("/camel-subsystem.xml");
                profile.addContent((Content)new Text("    "));
                profile.addContent((Content)ConfigSupport.loadElementFrom((URL)resource));
                profile.addContent((Content)new Text("\n    "));
            }
            if (enable || element == null) continue;
            element.getParentElement().removeContent((Content)element);
        }
    }

    private void updateSecurityDomain(ConfigContext context, boolean enable) {
        Namespace[] domainNamespaces = this.registry.getNamespaces("urn:jboss:domain");
        Namespace[] securityNamespaces = this.registry.getNamespaces("urn:jboss:domain:security");
        List profiles = ConfigSupport.findProfileElements((Document)context.getDocument(), (Namespace[])domainNamespaces);
        for (Element profile : profiles) {
            Element security = ConfigSupport.findChildElement((Element)profile, (String)"subsystem", (Namespace[])securityNamespaces);
            ConfigSupport.assertExists((Element)security, (String)"Did not find the security subsystem");
            Element domains = ConfigSupport.findChildElement((Element)security, (String)"security-domains", (Namespace[])securityNamespaces);
            ConfigSupport.assertExists((Element)domains, (String)"Did not find the <security-domains> element");
            Element domain = ConfigSupport.findElementWithAttributeValue((Element)domains, (String)"security-domain", (String)"name", (String)"hawtio-domain", (Namespace[])securityNamespaces);
            if (enable && domain == null) {
                URL resource = WildFlyCamelConfigPlugin.class.getResource("/hawtio-security-domain.xml");
                domains.addContent((Content)new Text("    "));
                domains.addContent((Content)ConfigSupport.loadElementFrom((URL)resource));
                domains.addContent((Content)new Text("\n            "));
            }
            if (enable || domain == null) continue;
            domain.getParentElement().removeContent((Content)domain);
        }
    }

    private void updateServergroup(boolean enable, ConfigContext context) {
        Namespace[] domainNamespaces = this.registry.getNamespaces("urn:jboss:domain");
        Element serverGroups = ConfigSupport.findChildElement((Element)context.getDocument().getRootElement(), (String)"server-groups", (Namespace[])domainNamespaces);
        Element camel = ConfigSupport.findElementWithAttributeValue((Element)serverGroups, (String)"server-group", (String)"name", (String)"camel-server-group", (Namespace[])domainNamespaces);
        if (enable && camel == null) {
            URL resource = WildFlyCamelConfigPlugin.class.getResource("/camel-servergroup.xml");
            Element serverGroup = ConfigSupport.loadElementFrom((URL)resource);
            serverGroups.addContent((Content)new Text("    "));
            serverGroups.addContent((Content)serverGroup);
            serverGroups.addContent((Content)new Text("\n    "));
            this.applyNamespace(serverGroup);
        }
        if (!enable && camel != null) {
            camel.getParentElement().removeContent((Content)camel);
        }
    }

    private void addProperty(Element systemProperties, Map<String, Element> propertiesByName, String name, String value, Namespace namespace) {
        if (!propertiesByName.containsKey(name)) {
            systemProperties.addContent((Content)new Text("   "));
            systemProperties.addContent((Content)new Element("property", namespace).setAttribute("name", name).setAttribute("value", value));
            systemProperties.addContent((Content)new Text("\n    "));
        }
    }

    private void removeProperty(Map<String, Element> propertiesByName, String name) {
        Element element = propertiesByName.get(name);
        if (element != null) {
            element.getParentElement().removeContent((Content)element);
        }
    }

    private void registerNamespaceVersions(NamespaceRegistry registry) {
        this.registry = registry;
        registry.registerNamespace("urn:jboss:domain", "1.8");
        registry.registerNamespace("urn:jboss:domain", "1.7");
        registry.registerNamespace(NS_CAMEL, "1.0");
        registry.registerNamespace("urn:jboss:domain:logging", "1.5");
        registry.registerNamespace("urn:jboss:domain:security", "1.2");
        registry.registerNamespace("urn:jboss:domain:weld", "1.0");
    }

    private void applyNamespace(Element element) {
        if (element.getParentElement() != null) {
            element.setNamespace(element.getParentElement().getNamespace());
        }
        for (Element child : element.getChildren()) {
            this.applyNamespace(child);
        }
    }
}

