/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.config;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.wildfly.extras.config.ConfigContext;
import org.wildfly.extras.config.ConfigPlugin;
import org.wildfly.extras.config.ConfigSupport;
import org.wildfly.extras.config.LayerConfig;

public final class WildFlyCamelConfigPlugin
implements ConfigPlugin {
    public static final Namespace NS_DOMAIN_40 = Namespace.getNamespace((String)"urn:jboss:domain:4.0");
    public static final Namespace NS_DOMAIN_41 = Namespace.getNamespace((String)"urn:jboss:domain:4.1");
    public static final Namespace NS_DOMAIN_42 = Namespace.getNamespace((String)"urn:jboss:domain:4.2");
    public static final Namespace[] NS_DOMAINS = new Namespace[]{NS_DOMAIN_42, NS_DOMAIN_41, NS_DOMAIN_40};
    public static final Namespace NS_CAMEL = Namespace.getNamespace((String)"urn:jboss:domain:camel:1.0");
    public static final Namespace NS_LOGGING = Namespace.getNamespace((String)"urn:jboss:domain:logging:3.0");
    public static final Namespace NS_SECURITY = Namespace.getNamespace((String)"urn:jboss:domain:security:1.2");
    public static final Namespace NS_WELD = Namespace.getNamespace((String)"urn:jboss:domain:weld:3.0");

    public String getConfigName() {
        return "camel";
    }

    public List<LayerConfig> getLayerConfigs() {
        return Arrays.asList(LayerConfig.FUSE_LAYER);
    }

    public void applyStandaloneConfigChange(ConfigContext context, boolean enable) {
        WildFlyCamelConfigPlugin.updateExtension(context, enable);
        WildFlyCamelConfigPlugin.updateSystemProperties(context, enable);
        WildFlyCamelConfigPlugin.updateSubsystem(context, enable);
        WildFlyCamelConfigPlugin.updateWeldConfig(context, enable);
        WildFlyCamelConfigPlugin.updateSecurityDomain(context, enable);
    }

    public void applyDomainConfigChange(ConfigContext context, boolean enable) {
        this.applyStandaloneConfigChange(context, enable);
        WildFlyCamelConfigPlugin.updateServergroup(enable, context);
    }

    private static void updateExtension(ConfigContext context, boolean enable) {
        Element extensions = ConfigSupport.findChildElement((Element)context.getDocument().getRootElement(), (String)"extensions", (Namespace[])NS_DOMAINS);
        ConfigSupport.assertExists((Element)extensions, (String)"Did not find the <extensions> element");
        Namespace namespace = extensions.getNamespace();
        Element element = ConfigSupport.findElementWithAttributeValue((Element)extensions, (String)"extension", (String)"module", (String)"org.wildfly.extension.camel", (Namespace[])NS_DOMAINS);
        if (enable && element == null) {
            extensions.addContent((Content)new Text("    "));
            extensions.addContent((Content)new Element("extension", namespace).setAttribute("module", "org.wildfly.extension.camel"));
            extensions.addContent((Content)new Text("\n    "));
        }
        if (!enable && element != null) {
            element.getParentElement().removeContent((Content)element);
        }
    }

    private static void updateSystemProperties(ConfigContext context, boolean enable) {
        Element rootElement = context.getDocument().getRootElement();
        Element extensions = ConfigSupport.findChildElement((Element)rootElement, (String)"extensions", (Namespace[])NS_DOMAINS);
        ConfigSupport.assertExists((Element)extensions, (String)"Did not find the <extensions> element");
        Namespace namespace = extensions.getNamespace();
        Element element = ConfigSupport.findChildElement((Element)rootElement, (String)"system-properties", (Namespace[])NS_DOMAINS);
        if (element == null) {
            element = new Element("system-properties", namespace);
            element.addContent((Content)new Text("\n    "));
            int pos = rootElement.indexOf((Content)extensions);
            rootElement.addContent(pos + 1, (Content)new Text("    "));
            rootElement.addContent(pos + 1, (Content)element);
            rootElement.addContent(pos + 1, (Content)new Text("\n"));
        }
        Map propertiesByName = ConfigSupport.mapByAttributeName((List)element.getChildren(), (String)"name");
        if (enable) {
            WildFlyCamelConfigPlugin.addProperty(element, propertiesByName, "hawtio.authenticationEnabled", "true");
            WildFlyCamelConfigPlugin.addProperty(element, propertiesByName, "hawtio.offline", "true");
            WildFlyCamelConfigPlugin.addProperty(element, propertiesByName, "hawtio.realm", "hawtio-domain");
        } else {
            WildFlyCamelConfigPlugin.removeProperty(propertiesByName, "hawtio.authenticationEnabled");
            WildFlyCamelConfigPlugin.removeProperty(propertiesByName, "hawtio.offline");
            WildFlyCamelConfigPlugin.removeProperty(propertiesByName, "hawtio.realm");
        }
    }

    private static void updateSubsystem(ConfigContext context, boolean enable) {
        List profiles = ConfigSupport.findProfileElements((Document)context.getDocument(), (Namespace[])NS_DOMAINS);
        for (Element profile : profiles) {
            Element element = profile.getChild("subsystem", NS_CAMEL);
            if (enable && element == null) {
                URL resource = WildFlyCamelConfigPlugin.class.getResource("/camel-subsystem.xml");
                profile.addContent((Content)new Text("    "));
                profile.addContent((Content)ConfigSupport.loadElementFrom((URL)resource));
                profile.addContent((Content)new Text("\n    "));
            }
            if (enable || element == null) continue;
            element.getParentElement().removeContent((Content)element);
        }
    }

    private static void updateWeldConfig(ConfigContext context, boolean enable) {
        List profiles = ConfigSupport.findProfileElements((Document)context.getDocument(), (Namespace[])NS_DOMAINS);
        for (Element profile : profiles) {
            Element weld = profile.getChild("subsystem", NS_WELD);
            if (weld == null) continue;
            if (enable) {
                weld.setAttribute("require-bean-descriptor", "true");
                continue;
            }
            weld.removeAttribute("require-bean-descriptor");
        }
    }

    private static void updateSecurityDomain(ConfigContext context, boolean enable) {
        List profiles = ConfigSupport.findProfileElements((Document)context.getDocument(), (Namespace[])NS_DOMAINS);
        for (Element profile : profiles) {
            Element security = profile.getChild("subsystem", NS_SECURITY);
            if (security == null) continue;
            Element domains = security.getChild("security-domains", NS_SECURITY);
            ConfigSupport.assertExists((Element)domains, (String)"Did not find the <security-domains> element");
            Element domain = ConfigSupport.findElementWithAttributeValue((Element)domains, (String)"security-domain", (String)"name", (String)"hawtio-domain", (Namespace[])new Namespace[]{NS_SECURITY});
            if (enable && domain == null) {
                URL resource = WildFlyCamelConfigPlugin.class.getResource("/hawtio-security-domain.xml");
                domains.addContent((Content)new Text("    "));
                domains.addContent((Content)ConfigSupport.loadElementFrom((URL)resource));
                domains.addContent((Content)new Text("\n            "));
            }
            if (enable || domain == null) continue;
            domain.getParentElement().removeContent((Content)domain);
        }
    }

    private static void updateServergroup(boolean enable, ConfigContext context) {
        Element serverGroups = ConfigSupport.findChildElement((Element)context.getDocument().getRootElement(), (String)"server-groups", (Namespace[])NS_DOMAINS);
        Element camel = ConfigSupport.findElementWithAttributeValue((Element)serverGroups, (String)"server-group", (String)"name", (String)"camel-server-group", (Namespace[])NS_DOMAINS);
        if (enable && camel == null) {
            URL resource = WildFlyCamelConfigPlugin.class.getResource("/camel-servergroup.xml");
            serverGroups.addContent((Content)new Text("    "));
            serverGroups.addContent((Content)ConfigSupport.loadElementFrom((URL)resource));
            serverGroups.addContent((Content)new Text("\n    "));
        }
        if (!enable && camel != null) {
            camel.getParentElement().removeContent((Content)camel);
        }
    }

    private static void addProperty(Element systemProperties, Map<String, Element> propertiesByName, String name, String value) {
        Namespace namespace = systemProperties.getNamespace();
        if (!propertiesByName.containsKey(name)) {
            systemProperties.addContent((Content)new Text("   "));
            systemProperties.addContent((Content)new Element("property", namespace).setAttribute("name", name).setAttribute("value", value));
            systemProperties.addContent((Content)new Text("\n    "));
        }
    }

    private static void removeProperty(Map<String, Element> propertiesByName, String name) {
        Element element = propertiesByName.get(name);
        if (element != null) {
            element.getParentElement().removeContent((Content)element);
        }
    }
}

