/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.undertow.wildfly.subsystem.extension;

import java.security.AccessController;
import org.wildfly.security.manager.action.GetContextClassLoaderAction;
import org.wildfly.security.manager.action.SetContextClassLoaderAction;

class SecurityActions {
    private SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        return System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader() : (ClassLoader)AccessController.doPrivileged(GetContextClassLoaderAction.getInstance());
    }

    static void setContextClassLoader(ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new SetContextClassLoaderAction(classLoader));
        }
    }
}

