/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.rest;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.gravia.utils.IOUtils;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.HttpRequest;

@RunWith(value=Arquillian.class)
@RunAsClient
public class RestExampleTest {
    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File("target/examples/example-camel-rest.war"));
    }

    @After
    public void tearDown() throws Exception {
        HttpRequest.HttpResponse response = HttpRequest.delete((String)this.getEndpointAddress("/rest/customer/")).throwExceptionOnFailure(false).getResponse();
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
    }

    @Test
    public void testCreateCustomer() throws Exception {
        HttpRequest.HttpResponse result = this.createCustomer();
        Assert.assertEquals((long)200L, (long)result.getStatusCode());
        Assert.assertTrue((boolean)result.getBody().contains("\"firstName\":\"John\",\"lastName\":\"Doe\""));
    }

    @Test
    public void testReadAllCustomers() throws Exception {
        String customersBefore = HttpRequest.get((String)this.getEndpointAddress("/rest/customer/")).getResponse().getBody();
        String customersAfter = this.createCustomer().getBody();
        Assert.assertEquals((Object)"[]", (Object)customersBefore);
        Assert.assertTrue((boolean)customersAfter.contains("\"firstName\":\"John\",\"lastName\":\"Doe\""));
    }

    @Test
    public void testReadCustomer() throws Exception {
        HttpRequest.HttpResponse createCustomerResponse = this.createCustomer();
        String responseBody = createCustomerResponse.getBody();
        String customerId = this.getCustomerIdFromJson(responseBody.split(":")[1]);
        HttpRequest.HttpResponse getCustomerResponse = HttpRequest.get((String)this.getEndpointAddress("/camel/customer/" + customerId)).getResponse();
        Assert.assertEquals((long)200L, (long)getCustomerResponse.getStatusCode());
        Assert.assertTrue((boolean)getCustomerResponse.getBody().contains("\"firstName\":\"John\",\"lastName\":\"Doe\""));
    }

    @Test
    public void testReadNonExistentCustomer() throws Exception {
        HttpRequest.HttpResponse getCustomerResponse = HttpRequest.get((String)this.getEndpointAddress("/camel/customer/99")).throwExceptionOnFailure(false).getResponse();
        Assert.assertEquals((long)404L, (long)getCustomerResponse.getStatusCode());
    }

    @Test
    public void testUpdateCustomer() throws Exception {
        HttpRequest.HttpResponse newCustomerResponse = this.createCustomer();
        String customerJson = newCustomerResponse.getBody().replace("John", "Foo").replace("Doe", "Bar");
        HttpRequest.HttpResponse updateCustomerResponse = HttpRequest.put((String)this.getEndpointAddress("/rest/customer/")).header("Content-Type", "application/json").content(customerJson).getResponse();
        Assert.assertEquals((long)200L, (long)updateCustomerResponse.getStatusCode());
    }

    @Test
    public void testUpdateUnmodifiedCustomer() throws Exception {
        HttpRequest.HttpResponse newCustomerResponse = this.createCustomer();
        HttpRequest.HttpResponse updateCustomerResponse = HttpRequest.put((String)this.getEndpointAddress("/rest/customer/")).header("Content-Type", "application/json").content(newCustomerResponse.getBody()).throwExceptionOnFailure(false).getResponse();
        Assert.assertEquals((long)304L, (long)updateCustomerResponse.getStatusCode());
    }

    @Test
    public void testUpdateNonExistentCustomer() throws Exception {
        HttpRequest.HttpResponse updateCustomerResponse = HttpRequest.put((String)this.getEndpointAddress("/rest/customer/")).header("Content-Type", "application/json").content(this.readFileFromClasspath("/rest/update-customer.json")).throwExceptionOnFailure(false).getResponse();
        Assert.assertEquals((long)404L, (long)updateCustomerResponse.getStatusCode());
    }

    @Test
    public void testDeleteCustomer() throws Exception {
        HttpRequest.HttpResponse createCustomerResponse = this.createCustomer();
        String responseBody = createCustomerResponse.getBody();
        String customerId = this.getCustomerIdFromJson(responseBody.split(":")[1]);
        HttpRequest.HttpResponse deleteCustomerResponse = HttpRequest.delete((String)this.getEndpointAddress("/rest/customer/" + customerId)).throwExceptionOnFailure(false).getResponse();
        Assert.assertEquals((long)200L, (long)deleteCustomerResponse.getStatusCode());
    }

    @Test
    public void testDeleteNonExistentCustomer() throws Exception {
        HttpRequest.HttpResponse response = HttpRequest.delete((String)this.getEndpointAddress("/rest/customer/99")).throwExceptionOnFailure(false).getResponse();
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
    }

    @Test
    public void testGreet() throws Exception {
        HttpRequest.HttpResponse response = HttpRequest.get((String)this.getEndpointAddress("/rest/greet/hello/Kermit")).getResponse();
        Assert.assertTrue((boolean)response.getBody().startsWith("Hello Kermit"));
    }

    private HttpRequest.HttpResponse createCustomer() throws Exception {
        return HttpRequest.post((String)this.getEndpointAddress("/camel/customer/")).header("Content-Type", "application/json").content(this.readFileFromClasspath("/rest/create-customer.json")).getResponse();
    }

    private String getCustomerIdFromJson(String s) {
        return s.replaceAll("[^\\d.]", "");
    }

    private String readFileFromClasspath(String resource) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyStream((InputStream)this.getClass().getResourceAsStream(resource), (OutputStream)out);
        return new String(out.toByteArray());
    }

    private String getEndpointAddress(String restPath) throws MalformedURLException {
        return "http://localhost:8080/example-camel-rest" + restPath;
    }
}

