/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.castor;

import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.core.subA.Customer;

@RunWith(value=Arquillian.class)
public class CastorIntegrationTest {
    private static final String CUSTOMER_XML = "<customer><last-name>Doe</last-name><first-name>John</first-name></customer>";

    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"castor-dataformat-tests");
        archive.addClasses(new Class[]{Customer.class});
        archive.addAsResource("castor/castor-mapping.xml", "castor-mapping.xml");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshal() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").marshal().castor("castor-mapping.xml");
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)new Customer("John", "Doe"), String.class);
            Assert.assertTrue((String)("Ends with: " + result), (boolean)result.endsWith(CUSTOMER_XML));
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnmarshal() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").unmarshal().castor("castor-mapping.xml");
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            Customer result = (Customer)producer.requestBody("direct:start", (Object)CUSTOMER_XML, Customer.class);
            Assert.assertEquals((Object)"John", (Object)result.getFirstName());
            Assert.assertEquals((Object)"Doe", (Object)result.getLastName());
        }
        finally {
            camelctx.stop();
        }
    }
}

