/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.cxf.ws;

import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.ws.Service;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.headers.Header;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wildfly.camel.test.cxf.ws.subA.Endpoint;
import org.wildfly.camel.test.cxf.ws.subA.EndpointImpl;
import org.xml.sax.InputSource;

@RunWith(value=Arquillian.class)
public class WebServiceProducerIntegrationTest {
    static final String SIMPLE_WAR = "simple.war";
    @ArquillianResource
    Deployer deployer;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"cxf-ws-producer-tests");
        archive.addClasses(new Class[]{Endpoint.class});
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleWar() throws Exception {
        this.deployer.deploy(SIMPLE_WAR);
        try {
            QName serviceName = new QName("http://wildfly.camel.test.cxf", "EndpointService");
            Service service = Service.create((URL)this.getWsdl("/simple"), (QName)serviceName);
            Endpoint port = (Endpoint)service.getPort(Endpoint.class);
            Assert.assertEquals((Object)"Hello Foo", (Object)port.echo("Foo"));
        }
        finally {
            this.deployer.undeploy(SIMPLE_WAR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCxfProducer() throws Exception {
        this.deployer.deploy(SIMPLE_WAR);
        try {
            DefaultCamelContext camelctx = new DefaultCamelContext();
            camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("direct:start").to("cxf://" + WebServiceProducerIntegrationTest.this.getEndpointAddress("/simple") + "?serviceClass=" + Endpoint.class.getName());
                }
            });
            camelctx.start();
            try {
                ProducerTemplate producer = camelctx.createProducerTemplate();
                String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
                Assert.assertEquals((Object)"Hello Kermit", (Object)result);
            }
            finally {
                camelctx.stop();
            }
        }
        finally {
            this.deployer.undeploy(SIMPLE_WAR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCxfSoapHeader() throws Exception {
        this.deployer.deploy(SIMPLE_WAR);
        try {
            DefaultCamelContext camelctx = new DefaultCamelContext();
            camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ((RouteDefinition)this.from("direct:start").process(new Processor(){

                        public void process(Exchange exchange) throws Exception {
                            ArrayList<SoapHeader> soapHeaders = new ArrayList<SoapHeader>();
                            String headerXml = "<?xml version=\"1.0\" encoding=\"utf-8\"?><input xmlns=\"http://wildfly.camel.test.cxf\">Kermit</input>";
                            SoapHeader soapHeader = new SoapHeader(new QName("http://wildfly.camel.test.cxf", "input"), (Object)WebServiceProducerIntegrationTest.this.getSoapHeaderElement(headerXml));
                            soapHeader.setDirection(Header.Direction.DIRECTION_IN);
                            soapHeaders.add(soapHeader);
                            exchange.getOut().setHeader(Header.HEADER_LIST, soapHeaders);
                        }
                    })).to("cxf://" + WebServiceProducerIntegrationTest.this.getEndpointAddress("/simple") + "?serviceClass=" + Endpoint.class.getName());
                }
            });
            camelctx.start();
            try {
                ProducerTemplate producer = camelctx.createProducerTemplate();
                String result = (String)producer.requestBody("direct:start", null, String.class);
                Assert.assertEquals((Object)"Hello Kermit", (Object)result);
            }
            finally {
                camelctx.stop();
            }
        }
        finally {
            this.deployer.undeploy(SIMPLE_WAR);
        }
    }

    private Element getSoapHeaderElement(String headerXml) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        StringReader stringReader = new StringReader(headerXml);
        InputSource inputSource = new InputSource(stringReader);
        Document parsedHeader = documentBuilderFactory.newDocumentBuilder().parse(inputSource);
        return parsedHeader.getDocumentElement();
    }

    private String getEndpointAddress(String contextPath) throws MalformedURLException {
        return "http://localhost:8080" + contextPath + "/EndpointService";
    }

    private URL getWsdl(String contextPath) throws MalformedURLException {
        return new URL(this.getEndpointAddress(contextPath) + "?wsdl");
    }

    @Deployment(name="simple.war", managed=false, testable=false)
    public static Archive<?> getSimpleWar() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)SIMPLE_WAR);
        archive.addClasses(new Class[]{Endpoint.class, EndpointImpl.class});
        return archive;
    }
}

