/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jaxb;

import java.io.InputStream;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.XMLUtils;
import org.wildfly.camel.test.jaxb.model.Customer;

@RunWith(value=Arquillian.class)
public class JAXBIntegrationTest {
    @Deployment
    public static WebArchive deployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxb-integration-tests.war");
        archive.addPackage(Customer.class.getPackage());
        archive.addClasses(new Class[]{XMLUtils.class});
        archive.addAsResource((Asset)new StringAsset("Customer"), "org/wildfly/camel/test/jaxb/model/jaxb.index");
        archive.addAsResource("jaxb/customer.xml", "customer.xml");
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                ManifestBuilder builder = new ManifestBuilder();
                builder.addManifestHeader("Dependencies", "org.jdom");
                return builder.openStream();
            }
        });
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJaxbMarshal() throws Exception {
        final JaxbDataFormat format = new JaxbDataFormat();
        format.setContextPath("org.wildfly.camel.test.jaxb.model");
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").marshal((DataFormatDefinition)format);
            }
        });
        InputStream input = this.getClass().getResourceAsStream("/customer.xml");
        String expected = XMLUtils.compactXML((InputStream)input);
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            Customer customer = new Customer("John", "Doe");
            String result = (String)producer.requestBody("direct:start", (Object)customer, String.class);
            Assert.assertEquals((Object)expected, (Object)XMLUtils.compactXML((String)result));
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJaxbUnmarshal() throws Exception {
        final JaxbDataFormat format = new JaxbDataFormat();
        format.setContextPath("org.wildfly.camel.test.jaxb.model");
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").unmarshal((DataFormatDefinition)format);
            }
        });
        InputStream input = this.getClass().getResourceAsStream("/customer.xml");
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            Customer customer = (Customer)producer.requestBody("direct:start", (Object)input, Customer.class);
            Assert.assertEquals((Object)"John", (Object)customer.getFirstName());
            Assert.assertEquals((Object)"Doe", (Object)customer.getLastName());
        }
        finally {
            camelctx.stop();
        }
    }
}

