/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.spring;

import javax.annotation.Resource;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ServiceStatus;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.smoke.subA.HelloBean;

@RunWith(value=Arquillian.class)
public class SpringBeanDeploymentTest {
    @Resource(name="java:jboss/camel/context/spring-context")
    CamelContext camelContext;

    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-deployment-tests.jar");
        archive.addClasses(new Class[]{HelloBean.class});
        archive.addAsResource("spring/bean-transform-camel-context.xml");
        archive.addAsManifestResource((Asset)new StringAsset(""), "beans.xml");
        return archive;
    }

    @Test
    public void testBeanTransformFromModule() throws Exception {
        Assert.assertNotNull((String)"CamelContext not null", (Object)this.camelContext);
        Assert.assertEquals((Object)ServiceStatus.Started, (Object)this.camelContext.getStatus());
        ProducerTemplate producer = this.camelContext.createProducerTemplate();
        String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
        Assert.assertEquals((Object)"Hello Kermit", (Object)result);
    }
}

