/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.spring;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ServiceStatus;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelContextRegistry;

@RunWith(value=Arquillian.class)
public class SpringMultipleDescriptorsTest {
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-multiple-tests");
        archive.addAsResource("spring/transform1-camel-context.xml", "transform1-camel-context.xml");
        archive.addAsResource("spring/transform2-camel-context.xml", "somedir/transform2-camel-context.xml");
        return archive;
    }

    @Test
    public void testTransform1() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("transform1");
        Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
        ProducerTemplate producer = camelctx.createProducerTemplate();
        String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
        Assert.assertEquals((Object)"Hello Kermit", (Object)result);
    }

    @Test
    public void testTransform2() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("transform2");
        Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
        ProducerTemplate producer = camelctx.createProducerTemplate();
        String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
        Assert.assertEquals((Object)"Hello2 Kermit", (Object)result);
    }
}

