/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.security;

import org.jboss.crypto.CryptoUtil;
import org.wildfly.camel.utils.IllegalArgumentAssertion;
import org.wildfly.extension.camel.security.UsernamePasswordPrincipal;

public class EncodedUsernamePasswordPrincipal
extends UsernamePasswordPrincipal {
    public EncodedUsernamePasswordPrincipal(String username, char[] password) {
        this("ApplicationRealm", username, password);
    }

    public EncodedUsernamePasswordPrincipal(String realm, String username, char[] password) {
        super(username, EncodedUsernamePasswordPrincipal.encryptPassword(realm, username, password));
    }

    public static char[] encryptPassword(String realm, String username, char[] password) {
        IllegalArgumentAssertion.assertNotNull((Object)realm, (String)"realm");
        IllegalArgumentAssertion.assertNotNull((Object)username, (String)"username");
        IllegalArgumentAssertion.assertNotNull((Object)password, (String)"password");
        String compined = username + ":" + realm + ":" + new String(password);
        return CryptoUtil.createPasswordHash((String)"MD5", (String)"hex", null, null, (String)compined).toCharArray();
    }
}

