/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.security;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class DomainDecisionManager
implements AccessDecisionManager {
    private final Set<String> requiredRoles = new HashSet<String>();

    public void setRole(String role) {
        this.requiredRoles.add(role);
    }

    public void decide(Authentication auth, Object object, Collection<ConfigAttribute> configs) {
        HashSet<String> required = new HashSet<String>(this.requiredRoles);
        Collection authorities = auth.getAuthorities();
        for (GrantedAuthority authority : authorities) {
            required.remove(authority.getAuthority());
        }
        if (!required.isEmpty()) {
            throw new AccessDeniedException("User does not have required roles: " + required);
        }
    }

    public boolean supports(ConfigAttribute attribute) {
        return false;
    }

    public boolean supports(Class<?> clazz) {
        return false;
    }
}

