/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimplePrincipal;
import org.wildfly.extension.camel.security.AbstractAuthorizationPolicy;
import org.wildfly.extension.camel.security.LoginContextBuilder;

public class DomainAuthorizationPolicy
extends AbstractAuthorizationPolicy {
    private final Set<String> requiredRoles = new HashSet<String>();

    public DomainAuthorizationPolicy roles(String ... roles) {
        for (String role : roles) {
            this.requiredRoles.add(role);
        }
        return this;
    }

    public void setRole(String role) {
        this.requiredRoles.add(role);
    }

    @Override
    protected LoginContext getLoginContext(String domain, String username, char[] password) throws LoginException {
        LoginContextBuilder builder = new LoginContextBuilder(LoginContextBuilder.Type.AUTHENTICATION).domain(domain);
        return builder.username(username).password(password).build();
    }

    @Override
    protected void authorize(LoginContext context) throws LoginException {
        HashSet<String> required = new HashSet<String>(this.requiredRoles);
        Set<Group> groups = context.getSubject().getPrincipals(Group.class);
        if (groups != null) {
            for (Group group : groups) {
                if (!"Roles".equals(group.getName())) continue;
                for (String role : this.requiredRoles) {
                    if (!group.isMember((Principal)new SimplePrincipal(role))) continue;
                    required.remove(role);
                }
            }
        }
        if (!required.isEmpty()) {
            throw new LoginException("User does not have required roles: " + required);
        }
    }
}

