/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.wildfly.extension.camel.security.LoginContextBuilder;

public class DomainAuthenticationManager
implements AuthenticationManager {
    public Authentication authenticate(Authentication auth) throws AuthenticationException {
        LoginContext context;
        if (!(auth instanceof UsernamePasswordAuthenticationToken)) {
            throw new BadCredentialsException("Unsupported authentication type: " + auth);
        }
        LoginContextBuilder builder = new LoginContextBuilder(LoginContextBuilder.Type.AUTHENTICATION);
        UsernamePasswordAuthenticationToken authToken = (UsernamePasswordAuthenticationToken)auth;
        Object details = auth.getDetails();
        builder.domain(details instanceof String ? (String)details : "other");
        Object principal = authToken.getPrincipal();
        if (!(principal instanceof String)) {
            throw new UsernameNotFoundException("Unsupported principal: " + principal);
        }
        builder.username((String)principal);
        Object credentials = authToken.getCredentials();
        if (!(credentials instanceof char[])) {
            throw new BadCredentialsException("Unsupported credentials: " + credentials);
        }
        builder.password((char[])credentials);
        try {
            context = builder.build();
        }
        catch (LoginException ex) {
            throw new AuthenticationServiceException("Cannot build login context", (Throwable)ex);
        }
        try {
            context.login();
        }
        catch (LoginException ex) {
            throw new AuthenticationServiceException("Password invalid/Password required", (Throwable)ex);
        }
        HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
        Set<Group> groups = context.getSubject().getPrincipals(Group.class);
        if (groups != null) {
            for (Group group : groups) {
                if (!"Roles".equals(group.getName())) continue;
                Enumeration members = group.members();
                while (members.hasMoreElements()) {
                    Principal member = (Principal)members.nextElement();
                    authorities.add(new SimpleGrantedAuthority(member.getName()));
                }
            }
        }
        UsernamePasswordAuthenticationToken result = new UsernamePasswordAuthenticationToken(principal, credentials, authorities);
        result.setDetails(details);
        return result;
    }
}

