/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.security.ClientLoginModule;
import org.wildfly.camel.utils.IllegalArgumentAssertion;
import org.wildfly.camel.utils.IllegalStateAssertion;
import org.wildfly.extension.camel.security.EncodedUsernamePasswordPrincipal;
import org.wildfly.extension.camel.security.SecurityActions;

public final class LoginContextBuilder {
    private final Type contextType;
    private String domain;
    private String username;
    private char[] password;

    public LoginContextBuilder(Type type) {
        IllegalArgumentAssertion.assertNotNull((Object)((Object)type), (String)"type");
        this.contextType = type;
    }

    public LoginContextBuilder username(String username) {
        this.username = username;
        return this;
    }

    public LoginContextBuilder password(char[] password) {
        this.password = Arrays.copyOf(password, password.length);
        return this;
    }

    public LoginContextBuilder encryptedPassword(char[] password) {
        return this.encryptedPassword("ApplicationRealm", password);
    }

    public LoginContextBuilder encryptedPassword(String realm, char[] password) {
        IllegalStateAssertion.assertNotNull((Object)this.username, (String)"Username cannot be null");
        this.password = EncodedUsernamePasswordPrincipal.encryptPassword(realm, this.username, password);
        return this;
    }

    public LoginContextBuilder domain(String domain) {
        this.domain = domain;
        return this;
    }

    public LoginContext build() throws LoginException {
        if (this.contextType == Type.CLIENT) {
            return this.getClientLoginContext();
        }
        if (this.contextType == Type.AUTHENTICATION) {
            return this.getAuthenticationLoginContext();
        }
        throw new IllegalStateException("Unsupported type: " + (Object)((Object)this.contextType));
    }

    private LoginContext getClientLoginContext() throws LoginException {
        Configuration config = new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("multi-threaded", "true");
                options.put("restore-login-identity", "true");
                AppConfigurationEntry clmEntry = new AppConfigurationEntry(ClientLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                return new AppConfigurationEntry[]{clmEntry};
            }
        };
        return this.getLoginContext(config);
    }

    private LoginContext getAuthenticationLoginContext() throws LoginException {
        return this.getLoginContext(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoginContext getLoginContext(Configuration config) throws LoginException {
        IllegalStateAssertion.assertNotNull((Object)this.username, (String)"username");
        IllegalStateAssertion.assertNotNull((Object)this.password, (String)"password");
        String configName = this.domain != null ? this.domain : "other";
        CallbackHandler cbh = new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback current : callbacks) {
                    if (current instanceof NameCallback) {
                        ((NameCallback)current).setName(LoginContextBuilder.this.username);
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        ((PasswordCallback)current).setPassword(LoginContextBuilder.this.password);
                        continue;
                    }
                    throw new UnsupportedCallbackException(current);
                }
            }
        };
        ClassLoader tccl = SecurityActions.getContextClassLoader();
        try {
            if (!(tccl instanceof ModuleClassLoader)) {
                ClassLoader modcl = LoginContextBuilder.class.getClassLoader();
                SecurityActions.setContextClassLoader(modcl);
            }
            LoginContext loginContext = new LoginContext(configName, new Subject(), cbh, config);
            return loginContext;
        }
        finally {
            SecurityActions.setContextClassLoader(tccl);
        }
    }

    public static enum Type {
        CLIENT,
        AUTHENTICATION;

    }
}

