/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.deployment;

import java.io.IOException;
import java.net.URL;
import org.apache.camel.CamelContext;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.modules.Module;
import org.jboss.vfs.VirtualFile;
import org.wildfly.camel.CamelConstants;
import org.wildfly.camel.CamelMessages;
import org.wildfly.camel.SpringCamelContextFactory;

public class CamelContextCreateProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        CamelContext camelctx;
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        String runtimeName = depUnit.getName();
        URL contextDefinitionURL = null;
        try {
            VirtualFile rootFile;
            VirtualFile child;
            contextDefinitionURL = runtimeName.endsWith("-camel-context.xml") ? ((VirtualFile)depUnit.getAttachment(Attachments.DEPLOYMENT_CONTENTS)).asFileURL() : ((child = (rootFile = ((ResourceRoot)depUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot()).getChild("META-INF/jboss-camel-context.xml")).isFile() ? child.asFileURL() : null);
        }
        catch (IOException ex) {
            throw CamelMessages.MESSAGES.cannotCreateCamelContext(ex, runtimeName);
        }
        if (contextDefinitionURL == null) {
            return;
        }
        try {
            Module module = (Module)depUnit.getAttachment(Attachments.MODULE);
            camelctx = SpringCamelContextFactory.createSpringCamelContext(contextDefinitionURL, (ClassLoader)module.getClassLoader());
        }
        catch (Exception ex) {
            throw CamelMessages.MESSAGES.cannotCreateCamelContext(ex, runtimeName);
        }
        depUnit.putAttachment(CamelConstants.CAMEL_CONTEXT_KEY, (Object)camelctx);
    }

    public void undeploy(DeploymentUnit depUnit) {
        depUnit.removeAttachment(CamelConstants.CAMEL_CONTEXT_KEY);
    }
}

