/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.service;

import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.modules.Module;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.camel.CamelComponentRegistry;
import org.wildfly.camel.CamelConstants;
import org.wildfly.camel.CamelLogger;

public class CamelBootstrapService
extends AbstractService<Void> {
    private final InjectedValue<CamelComponentRegistry> injectedComponentRegistry = new InjectedValue();

    public static ServiceController<Void> addService(ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler) {
        CamelBootstrapService service = new CamelBootstrapService();
        ServiceBuilder builder = serviceTarget.addService(CamelConstants.CAMEL_SUBSYSTEM_SERVICE_NAME, (Service)service);
        builder.addDependency(CamelConstants.CAMEL_COMPONENT_REGISTRY_SERVICE_NAME, CamelComponentRegistry.class, service.injectedComponentRegistry);
        builder.addListener((ServiceListener)verificationHandler);
        return builder.install();
    }

    private CamelBootstrapService() {
    }

    public void start(StartContext startContext) throws StartException {
        CamelLogger.LOGGER.infoActivatingSubsystem();
        CamelComponentRegistry registry = (CamelComponentRegistry)this.injectedComponentRegistry.getValue();
        registry.registerComponents(Module.getCallerModule());
    }
}

