/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.gravia.provision.DefaultEnvironment;
import org.jboss.gravia.provision.Environment;
import org.jboss.gravia.repository.DefaultRepositoryXMLReader;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.wildfly.camel.CamelConstants;
import org.wildfly.camel.CamelMessages;

public class EnvironmentService
extends AbstractService<Environment> {
    private Environment environment;

    public static ServiceController<Environment> addService(ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler) {
        EnvironmentService service = new EnvironmentService();
        ServiceBuilder builder = serviceTarget.addService(CamelConstants.ENVIRONMENT_SERVICE_NAME, (Service)service);
        builder.addListener((ServiceListener)verificationHandler);
        return builder.install();
    }

    private EnvironmentService() {
    }

    public void start(StartContext startContext) throws StartException {
        this.environment = new DefaultEnvironment("WildFly Environment");
        ModuleClassLoader classLoader = Module.getCallerModule().getClassLoader();
        Iterator itres = classLoader.iterateResources("META-INF/environment-content", false);
        while (itres.hasNext()) {
            org.jboss.modules.Resource modres = (org.jboss.modules.Resource)itres.next();
            try {
                InputStream input = modres.openStream();
                DefaultRepositoryXMLReader reader = new DefaultRepositoryXMLReader(input);
                Resource xmlres = reader.nextResource();
                while (xmlres != null) {
                    if (this.environment.getResource(xmlres.getIdentity()) == null) {
                        DefaultResourceBuilder builder = new DefaultResourceBuilder();
                        for (Capability cap : xmlres.getCapabilities(null)) {
                            builder.addCapability(cap.getNamespace(), cap.getAttributes(), cap.getDirectives());
                        }
                        for (Requirement req : xmlres.getRequirements(null)) {
                            builder.addCapability(req.getNamespace(), req.getAttributes(), req.getDirectives());
                        }
                        this.environment.addResource(builder.getResource());
                    }
                    xmlres = reader.nextResource();
                }
            }
            catch (IOException e) {
                throw CamelMessages.MESSAGES.cannotInstallResourceToEnvironment(modres.getName());
            }
        }
    }

    public Environment getValue() throws IllegalStateException {
        return this.environment;
    }
}

