/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.deployment;

import java.io.IOException;
import java.net.URL;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.gravia.repository.DefaultRepositoryXMLReader;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.repository.RepositoryStorage;
import org.jboss.gravia.resource.Resource;
import org.jboss.vfs.VirtualFile;
import org.wildfly.camel.CamelMessages;
import org.wildfly.extension.gravia.GraviaConstants;

public class RepositoryContentInstallProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        String runtimeName = depUnit.getName();
        URL contentURL = null;
        try {
            VirtualFile rootFile;
            VirtualFile child;
            contentURL = runtimeName.endsWith("-repository-content.xml") ? ((VirtualFile)depUnit.getAttachment(Attachments.DEPLOYMENT_CONTENTS)).asFileURL() : ((child = (rootFile = ((ResourceRoot)depUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot()).getChild("META-INF/jboss-repository-content.xml")).isFile() ? child.asFileURL() : null);
        }
        catch (IOException ex) {
            throw CamelMessages.MESSAGES.cannotCreateCamelContext(ex, runtimeName);
        }
        if (contentURL != null) {
            DefaultRepositoryXMLReader reader;
            Repository repository = (Repository)depUnit.getAttachment(GraviaConstants.REPOSITORY_KEY);
            try {
                reader = new DefaultRepositoryXMLReader(contentURL.openStream());
            }
            catch (IOException ex) {
                throw new DeploymentUnitProcessingException((Throwable)ex);
            }
            Resource res = reader.nextResource();
            while (res != null) {
                RepositoryStorage storage = (RepositoryStorage)repository.adapt(RepositoryStorage.class);
                if (storage.getResource(res.getIdentity()) == null) {
                    storage.addResource(res);
                }
                res = reader.nextResource();
            }
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
    }
}

