/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.deployment;

import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.wildfly.camel.CamelComponentRegistry;
import org.wildfly.camel.CamelConstants;

public class CamelComponentRegistrationProcessor
implements DeploymentUnitProcessor {
    static final AttachmentKey<AttachmentList<CamelComponentRegistry.CamelComponentRegistration>> COMPONENT_REGISTRATIONS = AttachmentKey.createList(CamelComponentRegistry.CamelComponentRegistration.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)depUnit.getAttachment(Attachments.MODULE);
        CamelComponentRegistry registry = (CamelComponentRegistry)depUnit.getAttachment(CamelConstants.CAMEL_COMPONENT_REGISTRY_KEY);
        for (CamelComponentRegistry.CamelComponentRegistration creg : registry.registerComponents(module)) {
            depUnit.addToAttachmentList(COMPONENT_REGISTRATIONS, (Object)creg);
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
        for (CamelComponentRegistry.CamelComponentRegistration sreg : depUnit.getAttachmentList(COMPONENT_REGISTRATIONS)) {
            sreg.unregister();
        }
    }
}

