/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.service;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.spi.ComponentResolver;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.Resource;
import org.jboss.modules.filter.PathFilters;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.wildfly.camel.CamelComponentRegistry;
import org.wildfly.camel.CamelConstants;
import org.wildfly.camel.CamelLogger;
import org.wildfly.camel.CamelMessages;

public class CamelComponentRegistryService
extends AbstractService<CamelComponentRegistry> {
    static final String[] componentNames = new String[]{"cxf", "jms", "jmx"};
    private CamelComponentRegistry componentRegistry;

    public static ServiceController<CamelComponentRegistry> addService(ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler) {
        CamelComponentRegistryService service = new CamelComponentRegistryService();
        ServiceBuilder builder = serviceTarget.addService(CamelConstants.CAMEL_COMPONENT_REGISTRY_SERVICE_NAME, (Service)service);
        builder.addListener((ServiceListener)verificationHandler);
        return builder.install();
    }

    private CamelComponentRegistryService() {
    }

    public void start(StartContext startContext) throws StartException {
        ServiceContainer serviceContainer = startContext.getController().getServiceContainer();
        ServiceTarget serviceTarget = startContext.getChildTarget();
        this.componentRegistry = new DefaultCamelComponentRegistry(serviceContainer, serviceTarget);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        for (String compName : componentNames) {
            Module module;
            try {
                ModuleIdentifier cmpid = ModuleIdentifier.create((String)("org.apache.camel.component." + compName));
                module = moduleLoader.loadModule(cmpid);
            }
            catch (ModuleLoadException ex) {
                throw new StartException((Throwable)ex);
            }
            this.componentRegistry.registerComponents(module);
        }
    }

    public CamelComponentRegistry getValue() {
        return this.componentRegistry;
    }

    static class DefaultCamelComponentRegistry
    implements CamelComponentRegistry {
        private final ServiceContainer serviceContainer;
        private final ServiceTarget serviceTarget;

        DefaultCamelComponentRegistry(ServiceContainer serviceContainer, ServiceTarget serviceTarget) {
            this.serviceContainer = serviceContainer;
            this.serviceTarget = serviceTarget;
        }

        @Override
        public ComponentResolver getComponent(String name) {
            ServiceController controller = this.serviceContainer.getService(this.getInternalServiceName(name));
            return controller != null ? (ComponentResolver)controller.getValue() : null;
        }

        @Override
        public Set<CamelComponentRegistry.CamelComponentRegistration> registerComponents(Module module) {
            Iterator itres;
            HashSet<CamelComponentRegistry.CamelComponentRegistration> registrations = new HashSet<CamelComponentRegistry.CamelComponentRegistration>();
            try {
                itres = module.iterateResources(PathFilters.getMetaInfServicesFilter());
            }
            catch (ModuleLoadException ex) {
                throw CamelMessages.MESSAGES.cannotLoadComponentFromModule(ex, module.getIdentifier());
            }
            while (itres.hasNext()) {
                Class type;
                Resource res = (Resource)itres.next();
                String fullname = res.getName();
                if (!fullname.startsWith("META-INF/services/org/apache/camel/component/")) continue;
                String cname = fullname.substring(fullname.lastIndexOf("/") + 1);
                Properties props = new Properties();
                try {
                    props.load(res.openStream());
                }
                catch (IOException ex) {
                    throw CamelMessages.MESSAGES.cannotLoadComponentFromModule(ex, module.getIdentifier());
                }
                String className = props.getProperty("class");
                try {
                    ModuleClassLoader classLoader = module.getClassLoader();
                    type = classLoader.loadClass(className);
                }
                catch (Exception ex) {
                    throw CamelMessages.MESSAGES.cannotLoadComponentType(ex, cname);
                }
                if (!Component.class.isAssignableFrom(type)) {
                    throw CamelMessages.MESSAGES.componentTypeException(type);
                }
                ComponentResolver resolver = new ComponentResolver(){

                    public Component resolveComponent(String name, CamelContext context) throws Exception {
                        return (Component)context.getInjector().newInstance(type);
                    }
                };
                registrations.add(this.registerComponent(cname, resolver));
            }
            return registrations;
        }

        @Override
        public CamelComponentRegistry.CamelComponentRegistration registerComponent(String name, final ComponentResolver resolver) {
            if (this.getComponent(name) != null) {
                throw CamelMessages.MESSAGES.camelComponentAlreadyRegistered(name);
            }
            CamelLogger.LOGGER.infoRegisterCamelComponent(name);
            ValueService service = new ValueService((Value)new ImmediateValue((Object)resolver));
            ServiceBuilder builder = this.serviceTarget.addService(this.getInternalServiceName(name), (Service)service);
            final ServiceController controller = builder.install();
            return new CamelComponentRegistry.CamelComponentRegistration(){

                @Override
                public ComponentResolver getComponentResolver() {
                    return resolver;
                }

                @Override
                public void unregister() {
                    controller.setMode(ServiceController.Mode.REMOVE);
                }
            };
        }

        private ServiceName getInternalServiceName(String name) {
            return CamelConstants.CAMEL_COMPONENT_BASE_NAME.append(new String[]{name});
        }
    }
}

