/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.handler;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.util.FileUtil;
import org.jboss.gravia.utils.IllegalArgumentAssertion;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.wildfly.extension.camel.CamelLogger;

final class WildFlyClassResolver
extends DefaultClassResolver {
    private final ModuleClassLoader classLoader;

    WildFlyClassResolver(Module module) {
        IllegalArgumentAssertion.assertNotNull((Object)module, (String)"module");
        this.classLoader = module.getClassLoader();
    }

    WildFlyClassResolver(ClassLoader classLoader) {
        IllegalArgumentAssertion.assertNotNull((Object)classLoader, (String)"classLoader");
        IllegalArgumentAssertion.assertTrue((Boolean)(classLoader instanceof ModuleClassLoader), (String)("ModuleClassLoader required: " + classLoader));
        this.classLoader = (ModuleClassLoader)classLoader;
    }

    protected Class<?> loadClass(String className, ClassLoader defaultClassLoader) {
        IllegalArgumentAssertion.assertNotNull((Object)className, (String)"className");
        Class loadedClass = null;
        try {
            loadedClass = this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            CamelLogger.LOGGER.warn("Cannot load: {}", (Object)className);
        }
        return loadedClass;
    }

    public InputStream loadResourceAsStream(String uri) {
        IllegalArgumentAssertion.assertNotNull((Object)uri, (String)"uri");
        String resolvedName = FileUtil.compactPath((String)uri, (char)'/');
        return this.classLoader.getResourceAsStream(resolvedName);
    }

    public URL loadResourceAsURL(String uri) {
        IllegalArgumentAssertion.assertNotNull((Object)uri, (String)"uri");
        String resolvedName = FileUtil.compactPath((String)uri, (char)'/');
        return this.classLoader.getResource(resolvedName);
    }

    public Enumeration<URL> loadAllResourcesAsURL(String packageName) {
        IllegalArgumentAssertion.assertNotNull((Object)packageName, (String)"packageName");
        try {
            return this.classLoader.getResources(packageName);
        }
        catch (IOException e) {
            CamelLogger.LOGGER.warn("Cannot load resources for: {}", (Object)packageName);
            return null;
        }
    }
}

