/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettings;
import org.wildfly.extension.camel.deployment.CamelIntegrationParser;

public final class CamelDependenciesProcessor
implements DeploymentUnitProcessor {
    private static final String GRAVIA_MODULE = "org.jboss.gravia";
    private static final String APACHE_CAMEL_MODULE = "org.apache.camel";
    private static final String APACHE_CAMEL_COMPONENT_MODULE = "org.apache.camel.component";
    private static final String WILDFLY_CAMEL_MODULE = "org.wildfly.extension.camel";
    private static final String JDK_EXTRAS_MODULE = "sun.jdk.ext";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        CamelDeploymentSettings camelDeploymentSettings = (CamelDeploymentSettings)unit.getAttachment(CamelIntegrationParser.ATTACHMENT_KEY);
        if (camelDeploymentSettings == null) {
            camelDeploymentSettings = new CamelDeploymentSettings();
        }
        if (!camelDeploymentSettings.isEnabled()) {
            return;
        }
        String runtimeName = unit.getName();
        if (runtimeName.startsWith("hawtio") && runtimeName.endsWith(".war")) {
            return;
        }
        ModuleLoader moduleLoader = (ModuleLoader)unit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        ModuleSpecification moduleSpec = (ModuleSpecification)unit.getAttachment(Attachments.MODULE_SPECIFICATION);
        moduleSpec.addUserDependency(new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)GRAVIA_MODULE), false, false, false, false));
        moduleSpec.addUserDependency(new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)WILDFLY_CAMEL_MODULE), false, false, false, false));
        moduleSpec.addUserDependency(new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)JDK_EXTRAS_MODULE), false, false, false, false));
        ModuleDependency moddep = new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)APACHE_CAMEL_MODULE), false, false, true, false);
        moddep.addImportFilter(PathFilters.getMetaInfFilter(), true);
        moduleSpec.addUserDependency(moddep);
        List<String> deploymentDefinedModules = camelDeploymentSettings.getModules();
        if (!deploymentDefinedModules.isEmpty()) {
            for (String name : deploymentDefinedModules) {
                moduleSpec.addUserDependency(new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)name), false, false, true, false));
            }
        } else {
            moddep = new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)APACHE_CAMEL_COMPONENT_MODULE), false, false, true, false);
            moddep.addImportFilter(PathFilters.isOrIsChildOf((String)"META-INF/cxf"), true);
            moduleSpec.addUserDependency(moddep);
        }
        moddep = new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)"org.apache.camel.component.cdi"), false, false, false, false);
        moddep.addImportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), true);
        moddep.addImportFilter(PathFilters.getMetaInfFilter(), true);
        moduleSpec.addUserDependency(moddep);
        moddep = new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)"org.apache.deltaspike.core.api"), false, false, false, false);
        moddep.addImportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), true);
        moddep.addImportFilter(PathFilters.getMetaInfFilter(), true);
        moduleSpec.addUserDependency(moddep);
        moddep = new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)"org.apache.deltaspike.core.impl"), false, false, false, false);
        moddep.addImportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), true);
        moddep.addImportFilter(PathFilters.getMetaInfFilter(), true);
        moduleSpec.addUserDependency(moddep);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

