/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import java.io.IOException;
import java.net.URL;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettings;

public class CamelContextDescriptorsProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        CamelDeploymentSettings depSettings = (CamelDeploymentSettings)depUnit.getAttachment(CamelDeploymentSettings.ATTACHMENT_KEY);
        if (depSettings.isDisabledByJbossAll() || !depSettings.isDeploymentValid() || depUnit.getParent() != null) {
            return;
        }
        String runtimeName = depUnit.getName();
        try {
            if (runtimeName.endsWith("-camel-context.xml")) {
                URL fileURL = ((VirtualFile)depUnit.getAttachment(Attachments.DEPLOYMENT_CONTENTS)).asFileURL();
                depSettings.addCamelContextUrl(fileURL);
            } else {
                VirtualFileFilter filter = new VirtualFileFilter(){

                    public boolean accepts(VirtualFile child) {
                        return child.isFile() && child.getName().endsWith("-camel-context.xml");
                    }
                };
                VirtualFile rootFile = ((ResourceRoot)depUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
                for (VirtualFile contextFile : rootFile.getChildrenRecursively(filter)) {
                    depSettings.addCamelContextUrl(contextFile.asFileURL());
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot create camel context: " + runtimeName, ex);
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
    }
}

