/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.ContextCreateHandlerRegistry;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettings;
import org.wildfly.extension.camel.handler.PackageScanClassResolverAssociationHandler;

public class PackageScanResolverProcessor
implements DeploymentUnitProcessor {
    public final void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        CamelDeploymentSettings depSettings = (CamelDeploymentSettings)depUnit.getAttachment(CamelDeploymentSettings.ATTACHMENT_KEY);
        if (!depSettings.isEnabled()) {
            return;
        }
        ContextCreateHandlerRegistry createHandlerRegistry = (ContextCreateHandlerRegistry)depUnit.getAttachment(CamelConstants.CONTEXT_CREATE_HANDLER_REGISTRY_KEY);
        ModuleClassLoader moduleClassLoader = ((Module)depUnit.getAttachment(Attachments.MODULE)).getClassLoader();
        PackageScanClassResolverAssociationHandler contextCreateHandler = new PackageScanClassResolverAssociationHandler(moduleClassLoader);
        depSettings.setClassResolverAssociationHandler(contextCreateHandler);
        createHandlerRegistry.addContextCreateHandler((ClassLoader)moduleClassLoader, contextCreateHandler);
    }

    public void undeploy(DeploymentUnit depUnit) {
        ContextCreateHandlerRegistry createHandlerRegistry = (ContextCreateHandlerRegistry)depUnit.getAttachment(CamelConstants.CONTEXT_CREATE_HANDLER_REGISTRY_KEY);
        CamelDeploymentSettings depSettings = (CamelDeploymentSettings)depUnit.getAttachment(CamelDeploymentSettings.ATTACHMENT_KEY);
        if (createHandlerRegistry != null) {
            ModuleClassLoader classLoader = ((Module)depUnit.getAttachment(Attachments.MODULE)).getClassLoader();
            createHandlerRegistry.removeContextCreateHandler((ClassLoader)classLoader, depSettings.getClassResolverAssociationHandler());
        }
    }
}

