/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.structure.JBossDescriptorPropertyReplacement;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettings;

public class CamelIntegrationParser
implements JBossAllXMLParser<CamelDeploymentSettings> {
    public static final String NAMESPACE_1_0 = "urn:jboss:jboss-camel:1.0";
    public static final QName ROOT_ELEMENT = new QName("urn:jboss:jboss-camel:1.0", "jboss-camel");
    private static final String APACHE_CAMEL_COMPONENT_MODULE = "org.apache.camel.component";
    private static final String CAMEL_COMPONENT_PREFIX = "camel-";

    public CamelDeploymentSettings parse(XMLExtendedStreamReader reader, DeploymentUnit deploymentUnit) throws XMLStreamException {
        return CamelIntegrationParser.parser(reader, JBossDescriptorPropertyReplacement.propertyReplacer((DeploymentUnit)deploymentUnit));
    }

    public static CamelDeploymentSettings parser(XMLExtendedStreamReader reader, PropertyReplacer replacer) throws XMLStreamException {
        CamelDeploymentSettings result = new CamelDeploymentSettings();
        CamelIntegrationParser.parseCamelIntegrationElement(reader, result, replacer);
        return result;
    }

    private static void parseCamelIntegrationElement(XMLExtendedStreamReader reader, CamelDeploymentSettings result, PropertyReplacer propertyReplacer) throws XMLStreamException {
        Element rootElement = Element.of(reader.getName());
        switch (rootElement) {
            case CAMEL_INTEGRATION: {
                String value = CamelIntegrationParser.getAttributeValue((XMLStreamReader)reader, Attribute.ENABLED, propertyReplacer);
                if (value == null || value.isEmpty()) {
                    result.setEnabled(true);
                    break;
                }
                result.setEnabled(Boolean.valueOf(value) == Boolean.TRUE);
                break;
            }
            default: {
                throw CamelIntegrationParser.unexpectedContent((XMLStreamReader)reader);
            }
        }
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case COMPONENT: {
                            CamelIntegrationParser.parseComponentElement(reader, result, propertyReplacer);
                            continue block11;
                        }
                        case COMPONENT_MODULE: {
                            CamelIntegrationParser.parseComponentModuleElement(reader, result, propertyReplacer);
                            continue block11;
                        }
                    }
                    throw CamelIntegrationParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw CamelIntegrationParser.unexpectedContent((XMLStreamReader)reader);
        }
        throw CamelIntegrationParser.endOfDocument(reader.getLocation());
    }

    private static void parseComponentElement(XMLExtendedStreamReader reader, CamelDeploymentSettings result, PropertyReplacer propertyReplacer) throws XMLStreamException {
        String value = CamelIntegrationParser.getAttributeValue((XMLStreamReader)reader, Attribute.NAME, propertyReplacer);
        if (value != null && !value.isEmpty()) {
            if (value.startsWith(CAMEL_COMPONENT_PREFIX)) {
                value = value.substring(CAMEL_COMPONENT_PREFIX.length());
            }
            value = "org.apache.camel.component." + value;
            result.addModule(value);
        }
        switch (reader.nextTag()) {
            case 2: {
                return;
            }
        }
        throw CamelIntegrationParser.unexpectedContent((XMLStreamReader)reader);
    }

    private static void parseComponentModuleElement(XMLExtendedStreamReader reader, CamelDeploymentSettings result, PropertyReplacer propertyReplacer) throws XMLStreamException {
        String value = CamelIntegrationParser.getAttributeValue((XMLStreamReader)reader, Attribute.NAME, propertyReplacer);
        if (value != null && !value.isEmpty()) {
            result.addModule(value);
        }
        switch (reader.nextTag()) {
            case 2: {
                return;
            }
        }
        throw CamelIntegrationParser.unexpectedContent((XMLStreamReader)reader);
    }

    private static XMLStreamException unexpectedContent(XMLStreamReader reader) {
        String kind;
        switch (reader.getEventType()) {
            case 10: {
                kind = "attribute";
                break;
            }
            case 12: {
                kind = "cdata";
                break;
            }
            case 4: {
                kind = "characters";
                break;
            }
            case 5: {
                kind = "comment";
                break;
            }
            case 11: {
                kind = "dtd";
                break;
            }
            case 8: {
                kind = "document end";
                break;
            }
            case 2: {
                kind = "element end";
                break;
            }
            case 15: {
                kind = "entity declaration";
                break;
            }
            case 9: {
                kind = "entity ref";
                break;
            }
            case 13: {
                kind = "namespace";
                break;
            }
            case 14: {
                kind = "notation declaration";
                break;
            }
            case 3: {
                kind = "processing instruction";
                break;
            }
            case 6: {
                kind = "whitespace";
                break;
            }
            case 7: {
                kind = "document start";
                break;
            }
            case 1: {
                kind = "element start";
                break;
            }
            default: {
                kind = "unknown";
            }
        }
        return new XMLStreamException("Unexpected content kind: " + kind + " at " + reader.getLocation());
    }

    private static String getAttributeValue(XMLStreamReader reader, Attribute attribute, PropertyReplacer propertyReplacer) throws XMLStreamException {
        return reader.getAttributeValue(null, attribute.getQName().getLocalPart());
    }

    private static XMLStreamException endOfDocument(Location location) {
        return new XMLStreamException("Expected end of document " + location);
    }

    static enum Attribute {
        NAME(new QName("name")),
        ENABLED(new QName("enabled")),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final QName qname;

        private Attribute(QName qname) {
            this.qname = qname;
        }

        public QName getQName() {
            return this.qname;
        }

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
            for (Attribute element : Attribute.values()) {
                if (element == UNKNOWN) continue;
                attributesMap.put(element.getQName(), element);
            }
            attributes = attributesMap;
        }
    }

    static enum Version {
        JBOSS_JPA_1_0,
        UNKNOWN;

    }

    static enum Element {
        CAMEL_INTEGRATION(ROOT_ELEMENT),
        COMPONENT(new QName("urn:jboss:jboss-camel:1.0", "component")),
        COMPONENT_MODULE(new QName("urn:jboss:jboss-camel:1.0", "component-module")),
        UNKNOWN(null);

        private static final Map<QName, Element> elements;
        private final QName qname;

        private Element(QName qname) {
            this.qname = qname;
        }

        public QName getQName() {
            return this.qname;
        }

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(CamelIntegrationParser.NAMESPACE_1_0, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>();
            for (Element element : Element.values()) {
                if (element == UNKNOWN) continue;
                elementsMap.put(element.getQName(), element);
            }
            elements = elementsMap;
        }
    }
}

