/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.security;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.AuthorizationPolicy;
import org.apache.camel.spi.RouteContext;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.wildfly.extension.camel.security.ClientLoginContext;
import org.wildfly.extension.camel.security.UsernamePasswordAuthentication;

public class ClientLoginAuthorizationPolicy
implements AuthorizationPolicy {
    public void beforeWrap(RouteContext routeContext, ProcessorDefinition<?> definition) {
    }

    public Processor wrap(RouteContext routeContext, final Processor processor) {
        return new Processor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(Exchange exchange) throws Exception {
                Subject subject = (Subject)exchange.getIn().getHeader("CamelAuthentication", Subject.class);
                if (subject == null) {
                    throw new SecurityException("Cannot obtain authentication subject from exchange: " + exchange);
                }
                String username = null;
                char[] password = null;
                for (Principal principal : subject.getPrincipals()) {
                    if (principal instanceof UsernamePasswordAuthentication) {
                        username = principal.getName();
                        password = ((UsernamePasswordAuthentication)principal).getPassword();
                        continue;
                    }
                    if (!(principal instanceof UsernamePasswordAuthenticationToken)) continue;
                    username = principal.getName();
                    Object credentials = ((UsernamePasswordAuthenticationToken)principal).getCredentials();
                    if (credentials instanceof String) {
                        password = ((String)credentials).toCharArray();
                        continue;
                    }
                    if (!(credentials instanceof char[])) continue;
                    password = (char[])credentials;
                }
                if (username == null || password == null) {
                    throw new SecurityException("Cannot obtain credentials from exchange: " + exchange);
                }
                LoginContext loginContext = ClientLoginContext.newLoginContext(username, password);
                loginContext.login();
                try {
                    processor.process(exchange);
                }
                finally {
                    loginContext.logout();
                }
            }
        };
    }
}

