/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.jboss.logging.Logger;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.maven.ChannelCoordinate;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.channel.version.VersionMatcher;

public class VersionResolverFactory
implements MavenVersionsResolver.Factory {
    private static final Logger LOG = Logger.getLogger(VersionResolverFactory.class);
    private final RepositorySystem system;
    private final RepositorySystemSession session;
    private final List<RemoteRepository> repositories;

    public VersionResolverFactory(RepositorySystem system, RepositorySystemSession session, List<RemoteRepository> repositories) {
        this.system = system;
        this.session = session;
        this.repositories = repositories;
    }

    public MavenVersionsResolver create() {
        MavenResolverImpl res = new MavenResolverImpl(this.system, this.session, this.repositories);
        return res;
    }

    public List<Channel> resolveChannels(List<ChannelCoordinate> channelCoords) throws UnresolvedMavenArtifactException, MalformedURLException {
        Objects.requireNonNull(channelCoords);
        ArrayList<Channel> channels = new ArrayList<Channel>();
        try (MavenVersionsResolver resolver = this.create();){
            for (ChannelCoordinate channelCoord : channelCoords) {
                if (channelCoord.getUrl() != null) {
                    Channel channel = ChannelMapper.from((URL)channelCoord.getUrl());
                    LOG.infof("Resolving channel at %s", (Object)channelCoord.getUrl());
                    channels.add(channel);
                    continue;
                }
                String version = channelCoord.getVersion();
                if (version == null) {
                    Set versions = resolver.getAllVersions(channelCoord.getGroupId(), channelCoord.getArtifactId(), channelCoord.getExtension(), channelCoord.getClassifier());
                    Optional latestVersion = VersionMatcher.getLatestVersion((Set)versions);
                    version = (String)latestVersion.orElseThrow(() -> {
                        throw new UnresolvedMavenArtifactException(String.format("Unable to resolve the latest version of channel %s:%s", channelCoord.getGroupId(), channelCoord.getArtifactId()));
                    });
                }
                LOG.infof("Resolving channel from Maven artifact %s:%s:%s", (Object)channelCoord.getGroupId(), (Object)channelCoord.getArtifactId(), (Object)version);
                File channelArtifact = resolver.resolveArtifact(channelCoord.getGroupId(), channelCoord.getArtifactId(), channelCoord.getExtension(), channelCoord.getClassifier(), version);
                Channel channel = ChannelMapper.from((URL)channelArtifact.toURI().toURL());
                channels.add(channel);
            }
        }
        return channels;
    }

    private class MavenResolverImpl
    implements MavenVersionsResolver {
        private final RepositorySystem system;
        private final RepositorySystemSession session;
        private final List<RemoteRepository> repositories;

        MavenResolverImpl(RepositorySystem system, RepositorySystemSession session, List<RemoteRepository> repositories) {
            this.system = system;
            this.session = session;
            this.repositories = repositories;
        }

        public Set<String> getAllVersions(String groupId, String artifactId, String extension, String classifier) {
            Objects.requireNonNull(groupId);
            Objects.requireNonNull(artifactId);
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, "[0,)");
            VersionRangeRequest versionRangeRequest = new VersionRangeRequest();
            versionRangeRequest.setArtifact((Artifact)artifact);
            if (this.repositories != null) {
                versionRangeRequest.setRepositories(this.repositories);
            }
            try {
                VersionRangeResult versionRangeResult = this.system.resolveVersionRange(this.session, versionRangeRequest);
                Set<String> versions = versionRangeResult.getVersions().stream().map(Version::toString).collect(Collectors.toSet());
                return versions;
            }
            catch (VersionRangeResolutionException e) {
                return Collections.emptySet();
            }
        }

        public File resolveArtifact(String groupId, String artifactId, String extension, String classifier, String version) throws UnresolvedMavenArtifactException {
            ArtifactResult result;
            Objects.requireNonNull(groupId);
            Objects.requireNonNull(artifactId);
            Objects.requireNonNull(version);
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, version);
            ArtifactRequest request = new ArtifactRequest();
            request.setArtifact((Artifact)artifact);
            if (this.repositories != null) {
                request.setRepositories(this.repositories);
            }
            try {
                result = this.system.resolveArtifact(this.session, request);
            }
            catch (ArtifactResolutionException ex) {
                throw new UnresolvedMavenArtifactException(ex.getLocalizedMessage(), (Throwable)ex);
            }
            return result.getArtifact().getFile();
        }

        public List<File> resolveArtifacts(List<ArtifactCoordinate> coordinates) throws UnresolvedMavenArtifactException {
            Objects.requireNonNull(coordinates);
            ArrayList<ArtifactRequest> requests = new ArrayList<ArtifactRequest>();
            for (ArtifactCoordinate coord : coordinates) {
                DefaultArtifact artifact = new DefaultArtifact(coord.getGroupId(), coord.getArtifactId(), coord.getClassifier(), coord.getExtension(), coord.getVersion());
                ArtifactRequest request = new ArtifactRequest();
                request.setArtifact((Artifact)artifact);
                if (this.repositories != null) {
                    request.setRepositories(this.repositories);
                }
                requests.add(request);
            }
            try {
                List artifactResults = this.system.resolveArtifacts(this.session, requests);
                return artifactResults.stream().map(ArtifactResult::getArtifact).map(Artifact::getFile).collect(Collectors.toList());
            }
            catch (ArtifactResolutionException ex) {
                throw new UnresolvedMavenArtifactException(ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
    }
}

