/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel.maven;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.transfer.MetadataTransferException;
import org.jboss.logging.Logger;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.channel.ArtifactTransferException;
import org.wildfly.channel.Repository;

class RetryHandler {
    private static final Logger LOG = Logger.getLogger(RetryHandler.class);
    private final int maxRetries;
    private final long timeout;
    private final TimeUnit timeUnit;

    RetryHandler(int maxRetries, long timeout, TimeUnit timeUnit) {
        this.maxRetries = maxRetries;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    List<File> attemptResolve(Supplier supplier, Function<ArtifactResolutionException, Set<ArtifactCoordinate>> mapper, Set<Repository> attemptedRepos) {
        RetryCounter retryCounter = new RetryCounter(attemptedRepos);
        while (true) {
            try {
                return supplier.get();
            }
            catch (ArtifactResolutionException ex) {
                Set<ArtifactCoordinate> failed = mapper.apply(ex);
                retryCounter.addRetry(failed, (Exception)((Object)ex));
                continue;
            }
            break;
        }
    }

    VersionRangeResult attemptResolveMetadata(java.util.function.Supplier<VersionRangeResult> supplier, Set<Repository> attemptedRepos) {
        RetryCounter retryCounter = new RetryCounter(attemptedRepos);
        while (true) {
            Optional<Exception> transferException;
            VersionRangeResult versionRangeResult = supplier.get();
            if (LOG.isDebugEnabled()) {
                for (Exception exception : versionRangeResult.getExceptions()) {
                    LOG.debug((Object)String.format("Error resolving maven artifact %s: %s", versionRangeResult.getRequest().getArtifact(), exception.getMessage()), (Throwable)exception);
                }
            }
            if (!(transferException = versionRangeResult.getExceptions().stream().filter(e -> e.getClass().equals(MetadataTransferException.class)).findFirst()).isPresent()) {
                return versionRangeResult;
            }
            Artifact artifact = versionRangeResult.getRequest().getArtifact();
            Set<ArtifactCoordinate> failed = Set.of(new ArtifactCoordinate(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getVersion()));
            retryCounter.addRetry(failed, transferException.get());
        }
    }

    static interface Supplier {
        public List<File> get() throws ArtifactResolutionException;
    }

    private class RetryCounter {
        private final Set<Repository> attemptedRepos;
        private int retryCount = 0;
        private Set<ArtifactCoordinate> lastFailed = Collections.emptySet();

        private RetryCounter(Set<Repository> attemptedRepos) {
            this.attemptedRepos = attemptedRepos;
        }

        private void addRetry(Set<ArtifactCoordinate> failed, Exception ex) throws ArtifactTransferException {
            if (!this.lastFailed.equals(failed)) {
                LOG.debugf("Resetting retry counter. The set of failing artifacts changed", new Object[0]);
                this.retryCount = 0;
            }
            if (this.retryCount++ < RetryHandler.this.maxRetries) {
                this.lastFailed = failed;
                LOG.debugf("Artifact resolution failed - retry #%d", this.retryCount);
                if (RetryHandler.this.timeout > 0L) {
                    try {
                        LOG.debugf("Pausing resolution retry for %dms", RetryHandler.this.timeout);
                        Thread.sleep(RetryHandler.this.timeUnit.toMillis(RetryHandler.this.timeout));
                    }
                    catch (InterruptedException e) {
                        throw new ArtifactTransferException(ex.getLocalizedMessage(), (Throwable)e, failed, this.attemptedRepos);
                    }
                }
            } else {
                LOG.debug((Object)"Max retry count reached, failed to resolve artifacts");
                throw new ArtifactTransferException(ex.getLocalizedMessage(), (Throwable)ex, failed, this.attemptedRepos);
            }
        }
    }
}

