/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.cloud.common;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jboss.dmr.ModelNode;
import org.junit.jupiter.api.Assertions;
import org.wildfly.test.cloud.common.ForwardedPortAction;

public class TestHelper {
    private KubernetesClient k8sClient;
    private String containerName;

    TestHelper(KubernetesClient k8sClient, String containerName) {
        this.k8sClient = k8sClient;
        this.containerName = containerName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public boolean waitUntilWildFlyIsReady(long delay) {
        return TestHelper.waitUntilWildFlyIsReady(this.k8sClient, this.getFirstPodName(), this.containerName, delay);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitUntilWildFlyIsReady(KubernetesClient k8sClient, String podName, String containerName, long delay) {
        long start = System.currentTimeMillis();
        long spent = System.currentTimeMillis() - start;
        while (spent < delay) {
            try (LocalPortForward p2222 = ((ServiceResource)k8sClient.services().withName(containerName)).portForward(9990);){
                String log;
                Assertions.assertTrue((boolean)p2222.isAlive());
                URL url = new URL("http://localhost:" + p2222.getLocalPort() + "/health/ready");
                HttpClient client = HttpClient.newBuilder().build();
                HttpRequest request = HttpRequest.newBuilder().uri(url.toURI()).GET().build();
                HttpResponse<Void> response = client.send(request, HttpResponse.BodyHandlers.discarding());
                if (response.statusCode() == 200 && (log = ((ContainerResource)((PodResource)k8sClient.pods().withName(podName)).inContainer((Object)containerName)).getLog()).contains("WFLYSRV0025")) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (IOException | InterruptedException | URISyntaxException p2222) {
                // empty catch block
            }
            if ((spent = System.currentTimeMillis() - start) >= delay) continue;
            try {
                Thread.sleep(delay / 10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.interrupted();
                return false;
            }
        }
        return false;
    }

    public ModelNode executeCLICommands(String ... commands) {
        return TestHelper.executeCLICommands(this.k8sClient, this.getFirstPodName(), this.containerName, commands);
    }

    public static ModelNode executeCLICommands(KubernetesClient client, String podName, String containerName, String ... commands) {
        String bashCmd = String.format("$JBOSS_HOME/bin/jboss-cli.sh  -c --commands=\"%s\"", Arrays.stream(commands).map(cmd -> TestHelper.escapeCommand(cmd)).collect(Collectors.joining(",")));
        String output = TestHelper.runCommand(client, podName, containerName, bashCmd, true);
        return ModelNode.fromString((String)output);
    }

    public String readFile(String filePath) {
        return TestHelper.readFile(this.k8sClient, this.getFirstPodName(), this.containerName, filePath);
    }

    public static String readFile(KubernetesClient client, String podName, String containerName, String filePath) {
        String bashCmd = String.format("cat %s", filePath);
        String output = TestHelper.runCommand(client, podName, containerName, bashCmd, true);
        return output;
    }

    public String runCommand(String bashCommand, boolean expectOutput) {
        return TestHelper.runCommand(this.k8sClient, this.getFirstPodName(), this.containerName, bashCommand, expectOutput);
    }

    public static String runCommand(KubernetesClient client, String podName, String containerName, String bashCommand, boolean expectOutput) {
        final CountDownLatch execLatch = new CountDownLatch(1);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        final AtomicBoolean errorDuringExecution = new AtomicBoolean(false);
        ((ContainerResource)((PodResource)client.pods().withName(podName)).inContainer((Object)containerName)).writingOutput((OutputStream)out).writingError((OutputStream)System.err).usingListener(new ExecListener(){

            public void onFailure(Throwable throwable, ExecListener.Response response) {
                errorDuringExecution.set(true);
                execLatch.countDown();
            }

            public void onClose(int i, String s) {
                execLatch.countDown();
            }
        }).exec(new String[]{"bash", "-c", bashCommand});
        try {
            boolean ok = execLatch.await(10L, TimeUnit.SECONDS);
            Assertions.assertTrue((boolean)ok, (String)"CLI Commands timed out");
            Assertions.assertFalse((boolean)errorDuringExecution.get());
        }
        catch (InterruptedException ok) {
            // empty catch block
        }
        String output = out.toString();
        if (expectOutput && output.trim().length() == 0) {
            throw new IllegalStateException("No output was found executing the command. This likely means an error happened in the bash layer. The full command is:\n" + bashCommand);
        }
        return output;
    }

    private static String escapeCommand(String cmd) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cmd.length(); ++i) {
            char c = cmd.charAt(i);
            if (c == '$' && sb.length() > 0 && sb.charAt(sb.length() - 1) != '\\') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static ModelNode checkAndGetResult(ModelNode result) {
        Assertions.assertTrue((boolean)"success".equals(result.get("outcome").asString()), (String)result.asString());
        return result.get("result");
    }

    public static void checkFailed(ModelNode result) {
        Assertions.assertTrue((boolean)"failed".equals(result.get("outcome").asString()));
    }

    public <R> R doWithWebPortForward(String path, ForwardedPortAction<R> action) throws Exception {
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        try (LocalPortForward p = ((ServiceResource)this.k8sClient.services().withName(this.containerName)).portForward(8080);){
            Assertions.assertTrue((boolean)p.isAlive());
            URL url = new URL("http://localhost:" + p.getLocalPort() + (String)path);
            R r = action.get(url);
            return r;
        }
    }

    private String getFirstPodName() {
        Pod pod = (Pod)((PodList)((FilterWatchListDeletable)this.k8sClient.pods().withLabel("app.kubernetes.io/name=" + this.containerName)).list()).getItems().get(0);
        return pod.getMetadata().getName();
    }

    public Map<String, String> getAllPodLogs() {
        LinkedHashMap<String, String> logs = new LinkedHashMap<String, String>();
        for (Pod pod : ((PodList)this.k8sClient.pods().list()).getItems()) {
            String name = pod.getMetadata().getName();
            String log = this.getPodLog(name);
            if (log == null) continue;
            logs.put(name, log);
        }
        return logs;
    }

    public String getPodLog(String podName) {
        Loggable loggable = (Loggable)this.k8sClient.pods().withName(podName);
        if (loggable != null) {
            return loggable.getLog();
        }
        return null;
    }
}

