/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.distribution;

import java.util.Set;
import java.util.function.UnaryOperator;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;

public interface CacheStreamFilter<T>
extends UnaryOperator<CacheStream<T>> {
    public static <T> CacheStreamFilter<T> identity() {
        return new CacheStreamFilter<T>(){

            @Override
            public CacheStream<T> apply(CacheStream<T> stream) {
                return stream;
            }
        };
    }

    public static <T> CacheStreamFilter<T> segments(final IntSet segments) {
        return new CacheStreamFilter<T>(){

            @Override
            public CacheStream<T> apply(CacheStream<T> stream) {
                return stream.filterKeySegments(segments).disableRehashAware();
            }
        };
    }

    public static <T> CacheStreamFilter<T> local(Cache<?, ?> cache) {
        DistributionManager distribution = cache.getAdvancedCache().getDistributionManager();
        LocalizedCacheTopology topology = distribution != null ? distribution.getCacheTopology() : null;
        return topology != null ? CacheStreamFilter.primary(topology.getWriteConsistentHash(), topology.getLocalAddress()) : CacheStreamFilter.identity();
    }

    public static <T> CacheStreamFilter<T> primary(ConsistentHash hash, Address member) {
        return hash != null ? CacheStreamFilter.segments(IntSets.from((Set)hash.getPrimarySegmentsForOwner(member))) : CacheStreamFilter.identity();
    }
}

