/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelConfigurator;
import org.jgroups.JChannel;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.util.SocketFactory;
import org.wildfly.clustering.cache.infinispan.marshalling.MediaTypes;
import org.wildfly.clustering.cache.infinispan.marshalling.UserMarshaller;
import org.wildfly.clustering.context.AbstractContext;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.function.Runnable;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContextBuilder;
import org.wildfly.clustering.server.jgroups.ForkChannelFactory;
import org.wildfly.clustering.server.jgroups.JChannelContext;

public class EmbeddedCacheManagerContext
extends AbstractContext<EmbeddedCacheManager> {
    private static final String CONTAINER_NAME = "ISPN";
    private final EmbeddedCacheManager manager;

    public EmbeddedCacheManagerContext(String clusterName, String memberName) {
        this((Context<JChannel>)new JChannelContext(clusterName, memberName));
    }

    public EmbeddedCacheManagerContext(JChannel channel) {
        this((Context<JChannel>)Context.of((Object)channel, (java.lang.Runnable)Runnable.empty()));
    }

    private EmbeddedCacheManagerContext(Context<JChannel> channel) {
        this.accept(() -> channel.close());
        try {
            ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
            UserMarshaller marshaller = new UserMarshaller((Supplier)MediaTypes.WILDFLY_PROTOSTREAM, (ByteBufferMarshaller)new ProtoStreamByteBufferMarshaller((ImmutableSerializationContext)((SerializationContextBuilder)SerializationContextBuilder.newInstance((ClassLoaderMarshaller)ClassLoaderMarshaller.of((ClassLoader)loader)).load(loader)).build()));
            ForkChannelFactory channelFactory = new ForkChannelFactory((JChannel)channel.get());
            JGroupsChannelConfigurator configurator = new JGroupsChannelConfigurator(){
                final /* synthetic */ Function val$channelFactory;
                final /* synthetic */ EmbeddedCacheManagerContext this$0;
                {
                    this.val$channelFactory = function;
                    this.this$0 = this$0;
                }

                public String getProtocolStackString() {
                    return null;
                }

                public List<ProtocolConfiguration> getProtocolStack() {
                    return null;
                }

                public String getName() {
                    return EmbeddedCacheManagerContext.CONTAINER_NAME;
                }

                public JChannel createChannel(String ignored) throws Exception {
                    return (JChannel)this.val$channelFactory.apply(EmbeddedCacheManagerContext.CONTAINER_NAME);
                }

                public void setSocketFactory(SocketFactory socketFactory) {
                }

                public void setDataSource(DataSource dataSource) {
                }
            };
            GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder().cacheManagerName(CONTAINER_NAME).classLoader(loader);
            try {
                builder.globalState().configurationStorage(ConfigurationStorage.VOLATILE).persistentLocation(Files.createTempDirectory(CONTAINER_NAME, new FileAttribute[0]).resolve(((JChannel)channel.get()).getName()).toString()).temporaryLocation(Files.createTempDirectory(CONTAINER_NAME, new FileAttribute[0]).resolve(((JChannel)channel.get()).getName()).toString());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            builder.transport().defaultTransport().clusterName(((JChannel)channel.get()).getClusterName()).nodeName(((JChannel)channel.get()).getName()).addProperty("channelConfigurator", (Object)configurator);
            builder.serialization().marshaller((Marshaller)marshaller).addContextInitializer(new SerializationContextInitializer(){

                @Deprecated
                public String getProtoFile() {
                    return null;
                }

                @Deprecated
                public String getProtoFileName() {
                    return null;
                }

                public void registerMarshallers(SerializationContext context) {
                }

                public void registerSchema(SerializationContext context) {
                }
            });
            this.manager = new DefaultCacheManager(new ConfigurationBuilderHolder(loader, builder), false);
            this.manager.start();
            this.accept(() -> ((EmbeddedCacheManager)this.manager).stop());
        }
        catch (Error | RuntimeException e) {
            this.close();
            throw e;
        }
    }

    public EmbeddedCacheManager get() {
        return this.manager;
    }
}

