/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.marshall;

import java.util.Set;
import org.infinispan.commons.dataconversion.ByteArrayWrapper;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.IdentityWrapper;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.UTF8Encoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.util.logging.Log;

public interface EncoderRegistry
extends org.infinispan.marshall.core.EncoderRegistry {
    public void unregisterTranscoder(MediaType var1);

    default public Object convert(Object object, MediaType fromType, MediaType toType) {
        if (object == null) {
            return null;
        }
        Transcoder transcoder = this.getTranscoder(fromType, toType);
        if (transcoder == null) {
            throw Log.CONTAINER.cannotFindTranscoder(fromType, toType);
        }
        return transcoder.transcode(object, fromType, toType);
    }

    @Deprecated(forRemoval=true, since="11.0")
    default public Encoder getEncoder(Class<? extends Encoder> encoderClass, short encoderId) {
        return switch (encoderId) {
            case 1 -> IdentityEncoder.INSTANCE;
            case 3 -> UTF8Encoder.INSTANCE;
            case 0 -> {
                if (encoderClass != null) {
                    yield Set.of(IdentityEncoder.INSTANCE, UTF8Encoder.INSTANCE).stream().filter(encoder -> encoder.getClass().equals(encoderClass)).findFirst().orElseThrow(() -> new IllegalArgumentException(encoderClass.getName()));
                }
                yield null;
            }
            default -> throw new IllegalArgumentException(Short.toString(encoderId));
        };
    }

    @Deprecated(forRemoval=true, since="11.0")
    default public boolean isRegistered(Class<? extends Encoder> encoderClass) {
        return false;
    }

    @Deprecated(forRemoval=true, since="11.0")
    default public Wrapper getWrapper(Class<? extends Wrapper> wrapperClass, byte wrapperId) {
        return switch (wrapperId) {
            case 3 -> IdentityWrapper.INSTANCE;
            case 1 -> ByteArrayWrapper.INSTANCE;
            case 0 -> {
                if (wrapperClass != null) {
                    yield Set.of(IdentityWrapper.INSTANCE, ByteArrayWrapper.INSTANCE).stream().filter(wrapper -> wrapper.getClass().equals(wrapperClass)).findFirst().orElseThrow(() -> new IllegalArgumentException(wrapperClass.getName()));
                }
                yield null;
            }
            default -> throw new IllegalArgumentException(Byte.toString(wrapperId));
        };
    }

    @Deprecated(forRemoval=true, since="11.0")
    default public void registerEncoder(Encoder encoder) {
        throw new UnsupportedOperationException();
    }

    @Deprecated(forRemoval=true, since="11.0")
    default public void registerWrapper(Wrapper wrapper) {
        throw new UnsupportedOperationException();
    }
}

