/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded;

import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.RetryConfig;
import jakarta.transaction.TransactionManager;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.wildfly.clustering.cache.CacheEntryMutatorFactory;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.infinispan.BasicCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheContainerConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheEntryComputerFactory;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheEntryMutatorFactory;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheProperties;

public interface EmbeddedCacheConfiguration
extends EmbeddedCacheContainerConfiguration,
BasicCacheConfiguration {
    public static EmbeddedCacheConfiguration of(final EmbeddedCacheManager container, final String cacheName) {
        return new EmbeddedCacheConfiguration(){

            @Override
            public <K, V> Cache<K, V> getCache() {
                return container.getCache(cacheName);
            }
        };
    }

    public static EmbeddedCacheConfiguration of(final Cache<?, ?> cache) {
        return new EmbeddedCacheConfiguration(){

            @Override
            public <K, V> Cache<K, V> getCache() {
                return cache;
            }
        };
    }

    public <K, V> Cache<K, V> getCache();

    @Override
    default public String getName() {
        return super.getName();
    }

    default public boolean isActive() {
        return this.getCache().getStatus().allowInvocations() && this.getCache().getCacheConfiguration().clustering().hash().capacityFactor() > Float.MIN_VALUE;
    }

    default public <K, V> CacheEntryMutatorFactory<K, V> getCacheEntryMutatorFactory() {
        return new EmbeddedCacheEntryMutatorFactory<K, V>(this.getWriteOnlyCache());
    }

    default public <K, V, O> CacheEntryMutatorFactory<K, O> getCacheEntryMutatorFactory(Function<O, BiFunction<Object, V, V>> functionFactory) {
        return new EmbeddedCacheEntryComputerFactory<K, V, O>(this.getWriteOnlyCache(), functionFactory);
    }

    default public Optional<TransactionManager> getTransactionManager() {
        return Optional.ofNullable(this.getCache().getAdvancedCache().getTransactionManager());
    }

    @Override
    default public EmbeddedCacheManager getCacheContainer() {
        return this.getCache().getCacheManager();
    }

    default public CacheProperties getCacheProperties() {
        return new EmbeddedCacheProperties(this.getCache());
    }

    default public boolean isFaultTolerant() {
        return false;
    }

    default public <K, V> Cache<K, V> getWriteCache() {
        return this.getCache();
    }

    default public <K, V> Cache<K, V> getReadForUpdateCache() {
        return this.getCacheProperties().isLockOnRead() ? this.getCache().getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK) : this.getCache();
    }

    default public <K, V> Cache<K, V> getTryLockCache() {
        return this.getCacheProperties().isLockOnWrite() ? this.getCache().getAdvancedCache().withFlags(new Flag[]{Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY}) : this.getCache();
    }

    default public <K, V> Cache<K, V> getTryReadForUpdateCache() {
        return this.getCacheProperties().isLockOnRead() ? this.getCache().getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY}) : this.getCache();
    }

    default public <K, V> Cache<K, V> getWriteOnlyCache() {
        ArrayList<Flag> flags = new ArrayList<Flag>(2);
        flags.add(Flag.IGNORE_RETURN_VALUES);
        if (this.isFaultTolerant()) {
            flags.add(Flag.FAIL_SILENTLY);
        }
        return this.getWriteCache().getAdvancedCache().withFlags(flags);
    }

    default public <K, V> Cache<K, V> getSilentWriteCache() {
        return this.getWriteOnlyCache().getAdvancedCache().withFlags(Flag.SKIP_LISTENER_NOTIFICATION);
    }

    default public RetryConfig getRetryConfig() {
        Cache cache = this.getCache();
        long timeout = cache.getCacheConfiguration().locking().lockAcquisitionTimeout();
        int attempts = 1;
        for (long interval = timeout; interval > 1L; interval /= 10L) {
            ++attempts;
        }
        return RetryConfig.custom().maxAttempts(attempts).failAfterMaxAttempts(true).intervalFunction(IntervalFunction.ofExponentialBackoff((Duration)Duration.ofMillis(1L), (double)10.0)).retryExceptions(new Class[]{CacheException.class, IOException.class, UncheckedIOException.class}).build();
    }

    default public Duration getStopTimeout() {
        return Duration.ofMillis(this.getCache().getCacheConfiguration().transaction().cacheStopTimeout());
    }
}

