/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.wildfly.clustering.cache.CacheEntryLocator;
import org.wildfly.clustering.function.BiFunction;
import org.wildfly.clustering.function.BiPredicate;

public interface BiCacheEntryLocator<I, K, V>
extends CacheEntryLocator<I, Map.Entry<K, V>> {
    public Map.Entry<CompletionStage<K>, CompletionStage<V>> findEntry(I var1);

    default public Map.Entry<CompletionStage<K>, CompletionStage<V>> tryEntry(I id) {
        return this.findEntry(id);
    }

    @Override
    default public CompletionStage<Map.Entry<K, V>> findValueAsync(I id) {
        Map.Entry<CompletionStage<K>, CompletionStage<V>> entry = this.findEntry(id);
        BiFunction entryFactory = Map::entry;
        return entry.getKey().thenCombine(entry.getValue(), entryFactory.orDefault((java.util.function.BiPredicate)BiPredicate.and(Objects::nonNull, Objects::nonNull), (Supplier)org.wildfly.clustering.function.Supplier.empty()));
    }

    @Override
    default public CompletionStage<Map.Entry<K, V>> tryValueAsync(I id) {
        Map.Entry<CompletionStage<K>, CompletionStage<V>> entry = this.tryEntry(id);
        BiFunction entryFactory = Map::entry;
        return entry.getKey().thenCombine(entry.getValue(), entryFactory.orDefault((java.util.function.BiPredicate)BiPredicate.and(Objects::nonNull, Objects::nonNull), (Supplier)org.wildfly.clustering.function.Supplier.empty()));
    }
}

