/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.function.Supplier;

public interface ContextReference<C>
extends java.util.function.Supplier<C>,
Consumer<C>,
UnaryOperator<C> {
    public static <C> ContextReference<C> fromThreadLocal(final ThreadLocal<C> threadLocal) {
        return new ContextReference<C>(){

            @Override
            public C get() {
                return threadLocal.get();
            }

            @Override
            public void accept(C context) {
                if (context != null) {
                    threadLocal.set(context);
                } else {
                    threadLocal.remove();
                }
            }
        };
    }

    public static <C> ContextReference<C> of(final AtomicReference<C> reference) {
        return new ContextReference<C>(){

            @Override
            public C get() {
                return reference.get();
            }

            @Override
            public void accept(C context) {
                reference.set(context);
            }

            @Override
            public C apply(C context) {
                return reference.getAndSet(context);
            }
        };
    }

    @Override
    default public C apply(C context) {
        Object current = this.get();
        this.accept(context);
        return (C)current;
    }

    default public java.util.function.Supplier<Context<C>> provide(final C target) {
        return target != null ? new Supplier<Context<C>>(){

            public Context<C> get() {
                final Object existing = ContextReference.this.get();
                if (existing == target) {
                    return Context.empty();
                }
                ContextReference.this.accept(target);
                return new Context<C>(){

                    @Override
                    public C get() {
                        return target;
                    }

                    @Override
                    public void close() {
                        ContextReference.this.accept(existing);
                    }
                };
            }
        } : Supplier.of(Context.empty());
    }
}

