/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.wildfly.clustering.function.BooleanSupplier;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.DoubleSupplier;
import org.wildfly.clustering.function.IntSupplier;
import org.wildfly.clustering.function.LongSupplier;
import org.wildfly.clustering.function.Runnable;

public interface Supplier<T>
extends java.util.function.Supplier<T> {
    public static final Supplier<?> NULL = () -> null;

    @Deprecated(forRemoval=true)
    default public <V> Supplier<V> map(Function<T, V> mapper) {
        return this.thenApply(mapper);
    }

    default public Runnable thenAccept(final Consumer<T> consumer) {
        return new Runnable(){

            @Override
            public void run() {
                consumer.accept(Supplier.this.get());
            }
        };
    }

    default public <R> Supplier<R> thenApply(final Function<T, R> function) {
        return new Supplier<R>(){

            @Override
            public R get() {
                return function.apply(Supplier.this.get());
            }
        };
    }

    default public DoubleSupplier thenApplyAsDouble(final ToDoubleFunction<T> mapper) {
        return new DoubleSupplier(){

            @Override
            public double getAsDouble() {
                return mapper.applyAsDouble(Supplier.this.get());
            }
        };
    }

    default public IntSupplier thenApplyAsInt(final ToIntFunction<T> mapper) {
        return new IntSupplier(){

            @Override
            public int getAsInt() {
                return mapper.applyAsInt(Supplier.this.get());
            }
        };
    }

    default public LongSupplier thenApplyAsLong(final ToLongFunction<T> mapper) {
        return new LongSupplier(){

            @Override
            public long getAsLong() {
                return mapper.applyAsLong(Supplier.this.get());
            }
        };
    }

    default public BooleanSupplier thenTest(final Predicate<T> predicate) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return predicate.test(Supplier.this.get());
            }
        };
    }

    default public Supplier<T> handle(final Function<RuntimeException, T> handler) {
        return new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return Supplier.this.get();
                }
                catch (RuntimeException e) {
                    return handler.apply(e);
                }
            }
        };
    }

    public static <T> Supplier<T> empty() {
        return NULL;
    }

    public static <T> Supplier<T> of(final T value) {
        return value != null ? new Supplier<T>(){

            @Override
            public T get() {
                return value;
            }
        } : Supplier.empty();
    }

    public static <T> Supplier<T> run(final java.lang.Runnable task) {
        return task != null ? new Supplier<T>(){

            @Override
            public T get() {
                task.run();
                return null;
            }
        } : Supplier.empty();
    }

    public static <T> Supplier<T> call(final Callable<T> caller, final Function<Exception, T> handler) {
        return caller != null ? new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return caller.call();
                }
                catch (Exception e) {
                    return handler.apply(e);
                }
            }
        } : Supplier.empty();
    }

    public static <K, V> Supplier<Map.Entry<K, V>> entry(final Supplier<K> key, final Supplier<V> value) {
        return new Supplier<Map.Entry<K, V>>(){

            @Override
            public Map.Entry<K, V> get() {
                return new AbstractMap.SimpleImmutableEntry(key.get(), value.get());
            }
        };
    }
}

