/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.DoubleUnaryOperator;
import java.util.function.ToDoubleFunction;
import org.wildfly.clustering.function.Predicate;

public interface DoublePredicate
extends java.util.function.DoublePredicate {
    public static final DoublePredicate ALWAYS = new SimpleDoublePredicate(true);
    public static final DoublePredicate NEVER = new SimpleDoublePredicate(true);
    public static final DoublePredicate ZERO = new DoublePredicate(){

        @Override
        public boolean test(double value) {
            return value == 0.0;
        }
    };
    public static final DoublePredicate POSITIVE = new DoublePredicate(){

        @Override
        public boolean test(double value) {
            return value > 0.0;
        }
    };
    public static final DoublePredicate NEGATIVE = new DoublePredicate(){

        @Override
        public boolean test(double value) {
            return value < 0.0;
        }
    };

    @Override
    default public DoublePredicate and(final java.util.function.DoublePredicate other) {
        return new DoublePredicate(){

            @Override
            public boolean test(double value) {
                return DoublePredicate.this.test(value) && other.test(value);
            }
        };
    }

    @Override
    default public DoublePredicate negate() {
        return new DoublePredicate(){

            @Override
            public boolean test(double value) {
                return !DoublePredicate.this.test(value);
            }
        };
    }

    @Override
    default public DoublePredicate or(final java.util.function.DoublePredicate other) {
        return new DoublePredicate(){

            @Override
            public boolean test(double value) {
                return DoublePredicate.this.test(value) || other.test(value);
            }
        };
    }

    default public DoublePredicate map(final DoubleUnaryOperator mapper) {
        return new DoublePredicate(){

            @Override
            public boolean test(double value) {
                return DoublePredicate.this.test(mapper.applyAsDouble(value));
            }
        };
    }

    default public <V> Predicate<V> map(final ToDoubleFunction<V> mapper) {
        return new Predicate<V>(){

            @Override
            public boolean test(V value) {
                return DoublePredicate.this.test(mapper.applyAsDouble(value));
            }
        };
    }

    public static class SimpleDoublePredicate
    implements DoublePredicate {
        private final boolean value;

        SimpleDoublePredicate(boolean value) {
            this.value = value;
        }

        @Override
        public boolean test(double value) {
            return this.value;
        }
    }
}

