/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.wildfly.clustering.function.BiFunction;
import org.wildfly.clustering.function.Consumer;

public interface BiConsumer<T, U>
extends java.util.function.BiConsumer<T, U> {
    public static final BiConsumer<?, ?> EMPTY = (value1, value2) -> {};

    @Override
    default public BiConsumer<T, U> andThen(java.util.function.BiConsumer<? super T, ? super U> after) {
        return BiConsumer.acceptAll(List.of(this, after));
    }

    default public <V1, V2> BiConsumer<V1, V2> compose(final Function<? super V1, T> mapper1, final Function<? super V2, U> mapper2) {
        return new BiConsumer<V1, V2>(this){
            final /* synthetic */ BiConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(V1 value1, V2 value2) {
                this.this$0.accept(mapper1.apply(value1), mapper2.apply(value2));
            }
        };
    }

    default public BiConsumer<U, T> reverse() {
        return new BiConsumer<U, T>(){

            @Override
            public void accept(U value1, T value2) {
                BiConsumer.this.accept(value2, value1);
            }
        };
    }

    default public BiConsumer<T, U> handle(final java.util.function.Consumer<RuntimeException> handler) {
        return new BiConsumer<T, U>(this){
            final /* synthetic */ BiConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(T value1, U value2) {
                try {
                    this.this$0.accept(value1, value2);
                }
                catch (RuntimeException e) {
                    handler.accept(e);
                }
            }
        };
    }

    default public <R> BiFunction<T, U, R> thenReturn(final Supplier<R> factory) {
        return new BiFunction<T, U, R>(this){
            final /* synthetic */ BiConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public R apply(T value1, U value2) {
                this.this$0.accept(value1, value2);
                return factory.get();
            }
        };
    }

    public static <T, U> BiConsumer<T, U> empty() {
        return EMPTY;
    }

    public static <T, U> BiConsumer<T, U> acceptFormer(java.util.function.Consumer<? super T> consumer) {
        return BiConsumer.of(consumer, Consumer.empty());
    }

    public static <T, U> BiConsumer<T, U> acceptLatter(java.util.function.Consumer<? super U> consumer) {
        return BiConsumer.of(Consumer.empty(), consumer);
    }

    public static <T, U> BiConsumer<T, U> of(final java.util.function.Consumer<? super T> consumer1, final java.util.function.Consumer<? super U> consumer2) {
        return new BiConsumer<T, U>(){

            @Override
            public void accept(T value1, U value2) {
                consumer1.accept(value1);
                consumer2.accept(value2);
            }
        };
    }

    public static <T, U> BiConsumer<T, U> acceptAll(final Iterable<? extends java.util.function.BiConsumer<? super T, ? super U>> consumers) {
        return new BiConsumer<T, U>(){

            @Override
            public void accept(T value1, U value2) {
                for (java.util.function.BiConsumer consumer : consumers) {
                    consumer.accept(value1, value2);
                }
            }
        };
    }

    public static <E extends Throwable> BiConsumer<String, E> throwing(final java.util.function.BiFunction<String, E, ? extends RuntimeException> exceptionFactory) {
        return new BiConsumer<String, E>(){

            @Override
            public void accept(String message, E cause) {
                throw (RuntimeException)exceptionFactory.apply(message, cause);
            }
        };
    }
}

