/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import org.wildfly.clustering.function.BiConsumer;
import org.wildfly.clustering.function.Consumer;

public interface IntConsumer
extends java.util.function.IntConsumer {
    public static final IntConsumer EMPTY = value -> {};

    @Override
    default public IntConsumer andThen(final java.util.function.IntConsumer after) {
        return new IntConsumer(){
            final /* synthetic */ IntConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(int value) {
                this.this$0.accept(value);
                after.accept(value);
            }
        };
    }

    default public Consumer<Integer> boxed() {
        return this.compose(Integer::intValue);
    }

    default public IntConsumer when(final IntPredicate predicate) {
        return new IntConsumer(){
            final /* synthetic */ IntConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(int value) {
                if (predicate.test(value)) {
                    this.this$0.accept(value);
                }
            }
        };
    }

    default public IntConsumer withDefault(final IntPredicate predicate, final IntSupplier defaultValue) {
        return new IntConsumer(){
            final /* synthetic */ IntConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(int value) {
                this.this$0.accept(predicate.test(value) ? value : defaultValue.getAsInt());
            }
        };
    }

    default public IntConsumer composeAsInt(final IntUnaryOperator composer) {
        return new IntConsumer(){
            final /* synthetic */ IntConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(int value) {
                this.this$0.accept(composer.applyAsInt(value));
            }
        };
    }

    default public <V> Consumer<V> compose(final ToIntFunction<V> composer) {
        return new Consumer<V>(this){
            final /* synthetic */ IntConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(V value) {
                this.this$0.accept(composer.applyAsInt(value));
            }
        };
    }

    default public <V1, V2> BiConsumer<V1, V2> compose(final ToIntBiFunction<V1, V2> composer) {
        return new BiConsumer<V1, V2>(this){
            final /* synthetic */ IntConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(V1 value1, V2 value2) {
                this.this$0.accept(composer.applyAsInt(value1, value2));
            }
        };
    }

    default public <R> IntFunction<R> thenReturn(final Supplier<R> factory) {
        return new IntFunction<R>(this){
            final /* synthetic */ IntConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public R apply(int value) {
                this.this$0.accept(value);
                return factory.get();
            }
        };
    }

    default public IntUnaryOperator thenReturnInt(final IntSupplier factory) {
        return new IntUnaryOperator(){
            final /* synthetic */ IntConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int applyAsInt(int value) {
                this.this$0.accept(value);
                return factory.getAsInt();
            }
        };
    }

    public static IntConsumer acceptAll(final Iterable<? extends IntConsumer> consumers) {
        return new IntConsumer(){

            @Override
            public void accept(int value) {
                for (IntConsumer consumer : consumers) {
                    consumer.accept(value);
                }
            }
        };
    }
}

