/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.AbstractMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Supplier;

public interface UnaryOperator<T>
extends java.util.function.UnaryOperator<T>,
Function<T, T> {
    public static final UnaryOperator<?> IDENTITY = value -> value;
    public static final UnaryOperator<?> NULL = value -> null;

    default public UnaryOperator<T> orDefault(final Predicate<T> predicate, final java.util.function.Supplier<T> defaultResult) {
        return new UnaryOperator<T>(this){
            final /* synthetic */ UnaryOperator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T apply(T value) {
                return predicate.test(value) ? this.this$0.apply(value) : defaultResult.get();
            }
        };
    }

    default public UnaryOperator<T> withDefault(final Predicate<T> predicate, final java.util.function.Supplier<T> defaultValue) {
        return new UnaryOperator<T>(this){
            final /* synthetic */ UnaryOperator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T apply(T value) {
                return this.this$0.apply(predicate.test(value) ? value : defaultValue.get());
            }
        };
    }

    default public UnaryOperator<T> andThen(final java.util.function.UnaryOperator<T> operator) {
        return new UnaryOperator<T>(this){
            final /* synthetic */ UnaryOperator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T apply(T value) {
                return operator.apply(this.this$0.apply(value));
            }
        };
    }

    default public UnaryOperator<T> compose(final java.util.function.UnaryOperator<T> operator) {
        return new UnaryOperator<T>(this){
            final /* synthetic */ UnaryOperator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T apply(T value) {
                return this.this$0.apply(operator.apply(value));
            }
        };
    }

    default public UnaryOperator<T> handle(final BiFunction<T, RuntimeException, T> handler) {
        return new UnaryOperator<T>(this){
            final /* synthetic */ UnaryOperator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T apply(T value) {
                try {
                    return this.this$0.apply(value);
                }
                catch (RuntimeException e) {
                    return handler.apply(value, e);
                }
            }
        };
    }

    public static <T> UnaryOperator<T> identity() {
        return IDENTITY;
    }

    public static <T> UnaryOperator<T> empty() {
        return NULL;
    }

    public static <T> UnaryOperator<T> of(final T value) {
        return value != null ? new UnaryOperator<T>(){

            @Override
            public T apply(T ignore) {
                return value;
            }
        } : UnaryOperator.empty();
    }

    public static <T> UnaryOperator<T> get(final java.util.function.Supplier<T> supplier) {
        return supplier != null && supplier != Supplier.NULL ? new UnaryOperator<T>(){

            @Override
            public T apply(T ignore) {
                return supplier.get();
            }
        } : UnaryOperator.empty();
    }

    public static <T> UnaryOperator<T> apply(final java.util.function.Function<? super T, T> function) {
        return function != null && function != Function.NULL ? new UnaryOperator<T>(){

            @Override
            public T apply(T value) {
                return function.apply(value);
            }
        } : UnaryOperator.empty();
    }

    public static <K, V> UnaryOperator<Map.Entry<K, V>> entry(final UnaryOperator<K> keyFunction, final UnaryOperator<V> valueFunction) {
        return new UnaryOperator<Map.Entry<K, V>>(){

            @Override
            public Map.Entry<K, V> apply(Map.Entry<K, V> entry) {
                return new AbstractMap.SimpleImmutableEntry(keyFunction.apply(entry.getKey()), valueFunction.apply(entry.getValue()));
            }
        };
    }
}

