/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Supplier;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.util.AbstractMapMarshaller;

public class MapMarshaller<T extends Map<Object, Object>>
extends AbstractMapMarshaller<T> {
    private final Supplier<T> factory;

    public MapMarshaller(Supplier<T> factory) {
        super(((Map)factory.get()).getClass());
        this.factory = factory;
    }

    @Override
    public T readFrom(ProtoStreamReader reader) throws IOException {
        Map map = (Map)this.factory.get();
        block3: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            switch (index) {
                case 1: {
                    Map.Entry entry = reader.readObject(AbstractMap.SimpleEntry.class);
                    map.put(entry.getKey(), entry.getValue());
                    continue block3;
                }
            }
            reader.skipField(tag);
        }
        return (T)map;
    }
}

