/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.Map;
import java.util.function.BiFunction;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class MapEntryMarshaller<K, V, T extends Map.Entry<K, V>>
implements ProtoStreamMarshaller<T> {
    private static final int KEY_INDEX = 1;
    private static final int VALUE_INDEX = 2;
    private final Class<? extends T> targetClass;
    private final BiFunction<K, V, T> factory;

    public MapEntryMarshaller(BiFunction<K, V, T> factory) {
        this.targetClass = ((Map.Entry)factory.apply(null, null)).getClass();
        this.factory = factory;
    }

    @Override
    public T readFrom(ProtoStreamReader reader) throws IOException {
        Object key = null;
        Object value = null;
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            switch (index) {
                case 1: {
                    key = reader.readAny();
                    continue block4;
                }
                case 2: {
                    value = reader.readAny();
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        return (T)((Map.Entry)this.factory.apply(key, value));
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, T entry) throws IOException {
        Object value;
        Object key = entry.getKey();
        if (key != null) {
            writer.writeAny(1, key);
        }
        if ((value = entry.getValue()) != null) {
            writer.writeAny(2, value);
        }
    }

    @Override
    public Class<? extends T> getJavaClass() {
        return this.targetClass;
    }
}

