/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.UUID;
import java.util.function.Function;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.util.UUIDBuilder;

public enum UUIDMarshaller implements FieldSetMarshaller.Supplied<UUID, UUIDBuilder>
{
    INSTANCE;

    private static final long DEFAULT_SIGNIFICANT_BITS = 0L;
    private static final int MOST_SIGNIFICANT_BITS_INDEX = 0;
    private static final int LEAST_SIGNIFICANT_BITS_INDEX = 1;
    private static final int FIELDS = 2;

    @Override
    public UUIDBuilder createInitialValue() {
        return new DefaultUUIDBuilder();
    }

    @Override
    public int getFields() {
        return 2;
    }

    @Override
    public UUIDBuilder readFrom(ProtoStreamReader reader, int index, WireType type, UUIDBuilder builder) throws IOException {
        return switch (index) {
            case 0 -> builder.setMostSignificantBits(reader.readSFixed64());
            case 1 -> builder.setLeastSignificantBits(reader.readSFixed64());
            default -> (UUIDBuilder)Supplier.call(() -> reader.skipField(type), null).thenApply((Function)org.wildfly.clustering.function.Function.of((Object)builder)).get();
        };
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, UUID uuid) throws IOException {
        long leastSignificantBits;
        long mostSignificantBits = uuid.getMostSignificantBits();
        if (mostSignificantBits != 0L) {
            writer.writeSFixed64(0, mostSignificantBits);
        }
        if ((leastSignificantBits = uuid.getLeastSignificantBits()) != 0L) {
            writer.writeSFixed64(1, leastSignificantBits);
        }
    }

    static class DefaultUUIDBuilder
    implements UUIDBuilder {
        private long mostSignificantBits = 0L;
        private long leastSignificantBits = 0L;

        DefaultUUIDBuilder() {
        }

        @Override
        public UUIDBuilder setMostSignificantBits(long bits) {
            this.mostSignificantBits = bits;
            return this;
        }

        @Override
        public UUIDBuilder setLeastSignificantBits(long bits) {
            this.leastSignificantBits = bits;
            return this;
        }

        @Override
        public UUID get() {
            return new UUID(this.mostSignificantBits, this.leastSignificantBits);
        }
    }
}

