/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.function.Function;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.FieldSetReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.util.AbstractCollectionMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.ComparatorMarshaller;

public class SortedSetMarshaller<E, T extends SortedSet<E>>
extends AbstractCollectionMarshaller<E, T> {
    private static final int COMPARATOR_INDEX = 2;
    private final Function<Comparator<? super E>, T> factory;

    public SortedSetMarshaller(Function<Comparator<? super E>, T> factory) {
        super(((SortedSet)factory.apply((Comparator<E>)ComparatorMarshaller.INSTANCE.createInitialValue())).getClass());
        this.factory = factory;
    }

    @Override
    public T readFrom(ProtoStreamReader reader) throws IOException {
        FieldSetReader<Object> comparatorReader = reader.createFieldSetReader(ComparatorMarshaller.INSTANCE, 2);
        Object comparator = ComparatorMarshaller.INSTANCE.createInitialValue();
        SortedSet set = (SortedSet)this.factory.apply((Comparator<E>)comparator);
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (index == 1) {
                Object element = reader.readAny();
                set.add(element);
                continue;
            }
            if (comparatorReader.contains(index)) {
                SortedSet existing = set;
                comparator = (Comparator)comparatorReader.readField(comparator);
                set = (SortedSet)this.factory.apply((Comparator<E>)comparator);
                set.addAll(existing);
                continue;
            }
            reader.skipField(tag);
        }
        return (T)set;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, T set) throws IOException {
        super.writeTo(writer, set);
        Comparator comparator = set.comparator();
        if (comparator != ComparatorMarshaller.INSTANCE.createInitialValue()) {
            writer.createFieldSetWriter(ComparatorMarshaller.INSTANCE, 2).writeFields(comparator);
        }
    }
}

