/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.InvalidClassException;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.Field;
import org.wildfly.clustering.marshalling.protostream.FieldMarshaller;
import org.wildfly.clustering.marshalling.protostream.FieldSetReader;
import org.wildfly.clustering.marshalling.protostream.Privileged;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.Scalar;
import org.wildfly.clustering.marshalling.protostream.ScalarClass;

public class LoadedClassField
implements Field<Class<?>>,
FieldMarshaller<Class<?>> {
    private final ClassLoaderMarshaller loaderMarshaller;
    private final int index;
    private final int loaderIndex;

    LoadedClassField(ClassLoaderMarshaller loaderMarshaller, int index) {
        this.loaderMarshaller = loaderMarshaller;
        this.index = index;
        this.loaderIndex = index + 1;
    }

    @Override
    public FieldMarshaller<Class<?>> getMarshaller() {
        return this;
    }

    @Override
    public Class<?> readFrom(ProtoStreamReader reader) throws IOException {
        String className = (String)Scalar.STRING.cast(String.class).readFrom(reader);
        FieldSetReader<ClassLoader> loaderReader = reader.createFieldSetReader(this.loaderMarshaller, this.loaderIndex);
        ClassLoader loader = (ClassLoader)this.loaderMarshaller.createInitialValue();
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (loaderReader.contains(index)) {
                loader = loaderReader.readField(loader);
                continue;
            }
            reader.skipField(tag);
        }
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            InvalidClassException exception = new InvalidClassException(e.getLocalizedMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, Class<?> targetClass) throws IOException {
        Scalar.STRING.writeTo(writer, targetClass.getName());
        writer.createFieldSetWriter(this.loaderMarshaller, this.loaderIndex).writeFields(Privileged.getClassLoader(targetClass));
    }

    @Override
    public Class<? extends Class<?>> getJavaClass() {
        return ScalarClass.ANY.getJavaClass();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public WireType getWireType() {
        return WireType.LENGTH_DELIMITED;
    }
}

