/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.FieldSetReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.time.LocalDateMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.LocalTimeMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.ZoneOffsetMarshaller;

public enum OffsetDateTimeMarshaller implements ProtoStreamMarshaller<OffsetDateTime>
{
    INSTANCE;

    private static final int DATE_INDEX = 1;
    private static final int TIME_INDEX;
    private static final int OFFSET_INDEX;

    @Override
    public OffsetDateTime readFrom(ProtoStreamReader reader) throws IOException {
        FieldSetReader<LocalDate> dateReader = reader.createFieldSetReader(LocalDateMarshaller.INSTANCE, 1);
        FieldSetReader<LocalTime> timeReader = reader.createFieldSetReader(LocalTimeMarshaller.INSTANCE, TIME_INDEX);
        FieldSetReader<ZoneOffset> offsetReader = reader.createFieldSetReader(ZoneOffsetMarshaller.INSTANCE, OFFSET_INDEX);
        LocalDate date = LocalDateMarshaller.INSTANCE.createInitialValue();
        LocalTime time = LocalTimeMarshaller.INSTANCE.createInitialValue();
        ZoneOffset offset = ZoneOffsetMarshaller.INSTANCE.createInitialValue();
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (dateReader.contains(index)) {
                date = dateReader.readField(date);
                continue;
            }
            if (timeReader.contains(index)) {
                time = timeReader.readField(time);
                continue;
            }
            if (offsetReader.contains(index)) {
                offset = offsetReader.readField(offset);
                continue;
            }
            reader.skipField(tag);
        }
        return OffsetDateTime.of(date, time, offset);
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, OffsetDateTime value) throws IOException {
        writer.createFieldSetWriter(LocalDateMarshaller.INSTANCE, 1).writeFields(value.toLocalDate());
        writer.createFieldSetWriter(LocalTimeMarshaller.INSTANCE, TIME_INDEX).writeFields(value.toLocalTime());
        writer.createFieldSetWriter(ZoneOffsetMarshaller.INSTANCE, OFFSET_INDEX).writeFields(value.getOffset());
    }

    @Override
    public Class<? extends OffsetDateTime> getJavaClass() {
        return OffsetDateTime.class;
    }

    static {
        TIME_INDEX = LocalDateMarshaller.INSTANCE.nextIndex(1);
        OFFSET_INDEX = LocalTimeMarshaller.INSTANCE.nextIndex(TIME_INDEX);
    }
}

