/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.stream.IntStream;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.util.Reflect;

class EnumSetMarshaller<E extends Enum<E>>
implements ProtoStreamMarshaller<EnumSet<E>> {
    static final ProtoStreamMarshaller<?> INSTANCE = new EnumSetMarshaller();
    static final Field ENUM_SET_CLASS_FIELD = Reflect.findField(EnumSet.class, Class.class);
    private static final int CLASS_INDEX = 1;
    private static final int COMPLEMENT_CLASS_INDEX = 2;
    private static final int BITS_INDEX = 3;
    private static final int ELEMENT_INDEX = 4;

    EnumSetMarshaller() {
    }

    @Override
    public Class<? extends EnumSet<E>> getJavaClass() {
        return EnumSet.class;
    }

    @Override
    public EnumSet<E> readFrom(ProtoStreamReader reader) throws IOException {
        IntStream.Builder elements = IntStream.builder();
        Class enumClass = null;
        boolean complement = false;
        BitSet bits = null;
        block6: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 2: {
                    complement = true;
                }
                case 1: {
                    enumClass = reader.readObject(Class.class);
                    continue block6;
                }
                case 3: {
                    bits = reader.readObject(BitSet.class);
                    continue block6;
                }
                case 4: {
                    elements.accept(reader.readUInt32());
                    continue block6;
                }
            }
            reader.skipField(tag);
        }
        EnumSet<Enum> set = EnumSet.noneOf(enumClass);
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        if (bits != null) {
            for (int i = 0; i < values.length; ++i) {
                if (!bits.get(i)) continue;
                set.add(values[i]);
            }
        } else {
            elements.build().mapToObj(index -> values[index]).forEach(set::add);
        }
        return complement ? EnumSet.complementOf(set) : set;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, EnumSet<E> set) throws IOException {
        EnumSet<E> targetSet;
        Class<E> enumClass = this.findEnumClass(set);
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        boolean complement = set.size() * 2 > values.length;
        writer.writeObject(complement ? 2 : 1, enumClass);
        EnumSet<E> enumSet = targetSet = complement ? EnumSet.complementOf(set) : set;
        if ((values.length + 8 - 1) / 8 < targetSet.size()) {
            BitSet bits = new BitSet(values.length);
            for (int i = 0; i < values.length; ++i) {
                bits.set(i, targetSet.contains(values[i]));
            }
            writer.writeObject(3, bits);
        } else {
            for (Enum value : targetSet) {
                writer.writeUInt32(4, value.ordinal());
            }
        }
    }

    private Class<E> findEnumClass(EnumSet<E> set) {
        EnumSet<E> nonEmptySet = set.isEmpty() ? EnumSet.complementOf(set) : set;
        Iterator values = nonEmptySet.iterator();
        if (!values.hasNext()) {
            throw new IllegalStateException();
        }
        return ((Enum)values.next()).getDeclaringClass();
    }
}

